/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.DungeonBase;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.worldgen.BlockFactoryCheckers;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsEnder
extends DungeonBase {
    World world;
    Random rand;
    byte dungeonHeight = (byte)10;
    int dungeonLength = 4;
    int dungeonWidth = 4;

    @Override
    public boolean generate(World inWorld, Random inRandom, CatacombLevelSettings settings, Cardinal[] entrances, Coord origin) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        this.world = inWorld;
        this.rand = inRandom;
        MetaBlock black = new MetaBlock(Blocks.field_150343_Z);
        MetaBlock white = new MetaBlock(Blocks.field_150371_ca);
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        for (int blockX = x - this.dungeonLength - 1; blockX <= x + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = z - this.dungeonWidth - 1; blockZ <= z + this.dungeonWidth + 1; ++blockZ) {
                for (int blockY = y - 1; blockY <= y + this.dungeonHeight; ++blockY) {
                    int height = y + this.rand.nextInt(8) + 2;
                    if (blockY > height) continue;
                    if (blockX == x - this.dungeonLength - 1 || blockZ == z - this.dungeonWidth - 1 || blockX == x + this.dungeonLength + 1 || blockZ == z + this.dungeonWidth + 1) {
                        if (blockY >= 0 && !this.world.func_147439_a(blockX, blockY - 1, blockZ).func_149688_o().func_76220_a()) {
                            WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, air);
                            continue;
                        }
                        if (!this.world.func_147439_a(blockX, blockY, blockZ).func_149688_o().func_76220_a()) continue;
                        WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, black);
                        continue;
                    }
                    WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, air);
                }
            }
        }
        BlockFactoryCheckers checkers = new BlockFactoryCheckers(black, white);
        WorldGenPrimitive.fillRectSolid(inWorld, inRandom, x - 4, y - 1, z - 4, x + 4, y - 1, z + 4, checkers, true, true);
        Spawner.generate(this.world, this.rand, settings, new Coord(x, y, z), Spawner.ENDERMAN);
        return true;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

