/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.segment.ISegment;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import java.util.Random;
import net.minecraft.world.World;

public abstract class SegmentBase
implements ISegment {
    @Override
    public void generate(World world, Random rand, CatacombLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        if (level.hasNearbyNode(x, z)) {
            return;
        }
        if (this.isValidWall(world, dir, x, y, z)) {
            this.genWall(world, rand, level, dir, theme, x, y, z);
        }
    }

    protected abstract void genWall(World var1, Random var2, CatacombLevel var3, Cardinal var4, ITheme var5, int var6, int var7, int var8);

    protected boolean isValidWall(World world, Cardinal wallDirection, int x, int y, int z) {
        switch (wallDirection) {
            case NORTH: {
                if (world.func_147437_c(x - 1, y + 1, z - 2)) {
                    return false;
                }
                if (!world.func_147437_c(x + 1, y + 1, z - 2)) break;
                return false;
            }
            case SOUTH: {
                if (world.func_147437_c(x - 1, y + 1, z + 2)) {
                    return false;
                }
                if (!world.func_147437_c(x + 1, y + 1, z + 2)) break;
                return false;
            }
            case EAST: {
                if (world.func_147437_c(x + 2, y + 1, z - 1)) {
                    return false;
                }
                if (!world.func_147437_c(x + 2, y + 1, z + 1)) break;
                return false;
            }
            case WEST: {
                if (world.func_147437_c(x - 2, y + 1, z - 1)) {
                    return false;
                }
                if (!world.func_147437_c(x - 2, y + 1, z + 1)) break;
                return false;
            }
        }
        return true;
    }
}

