/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.catacomb.settings.CatacombSettingsBlank;
import greymerk.roguelike.catacomb.settings.CatacombTowerSettings;
import greymerk.roguelike.catacomb.settings.ICatacombSettings;
import greymerk.roguelike.catacomb.settings.SpawnCriteria;
import greymerk.roguelike.catacomb.theme.Theme;
import greymerk.roguelike.catacomb.tower.Tower;
import greymerk.roguelike.worldgen.Coord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;

public class CatacombSettings
implements ICatacombSettings {
    public static final int MAX_NUM_LEVELS = 5;
    private String name;
    protected CatacombTowerSettings towerSettings;
    protected Map<Integer, CatacombLevelSettings> levels;
    protected SpawnCriteria criteria;
    protected int depth;

    public CatacombSettings() {
        this.levels = new HashMap<Integer, CatacombLevelSettings>();
        this.depth = 0;
    }

    public CatacombSettings(Map<String, CatacombSettings> settings, JsonObject root) throws Exception {
        this.name = root.get("name").getAsString();
        if (root.has("criteria")) {
            this.criteria = new SpawnCriteria(root.get("criteria").getAsJsonObject());
        }
        if (root.has("depth")) {
            int depth = root.get("depth").getAsInt();
            if (depth < 1) {
                this.depth = 1;
            }
            if (depth > 5) {
                this.depth = 5;
            }
            this.depth = depth;
        }
        if (root.has("tower")) {
            this.towerSettings = new CatacombTowerSettings(root.get("tower"));
        }
        this.levels = new HashMap<Integer, CatacombLevelSettings>();
        ArrayList<String> inheritList = new ArrayList<String>();
        if (root.has("inherit")) {
            JsonArray inherit = root.get("inherit").getAsJsonArray();
            for (JsonElement e : inherit) {
                inheritList.add(e.getAsString());
            }
        }
        CatacombSettings base = new CatacombSettingsBlank();
        for (String name : inheritList) {
            if (settings.containsKey(name)) {
                base = new CatacombSettings(base, settings.get(name));
                continue;
            }
            throw new Exception(name + " must be previously defined in order to be inherited");
        }
        this.parseJson(base, root);
    }

    private void parseJson(CatacombSettings base, JsonObject root) {
        if (!root.has("tower")) {
            this.towerSettings = base.towerSettings;
        }
        if (!root.has("depth")) {
            this.depth = base.depth;
        }
        if (!root.has("levels")) {
            this.levels.putAll(base.levels);
            return;
        }
        JsonObject levelSet = root.get("levels").getAsJsonObject();
        for (int i = 0; i < 5; ++i) {
            JsonObject data;
            CatacombLevelSettings setting = new CatacombLevelSettings();
            if (levelSet.has("all")) {
                data = levelSet.get("all").getAsJsonObject();
                setting = new CatacombLevelSettings(setting, new CatacombLevelSettings(data));
            }
            if (levelSet.has(Integer.toString(i))) {
                data = levelSet.get(Integer.toString(i)).getAsJsonObject();
                setting = new CatacombLevelSettings(setting, new CatacombLevelSettings(data));
            }
            this.levels.put(i, setting);
        }
    }

    public CatacombSettings(CatacombSettings base, CatacombSettings override) {
        this.depth = override.depth != 0 ? override.depth : base.depth;
        this.towerSettings = override.towerSettings == null ? base.towerSettings : override.towerSettings;
        this.levels = new HashMap<Integer, CatacombLevelSettings>();
        for (int i = 0; i < 5; ++i) {
            if (override.levels.get(i) == null) {
                this.levels.put(i, new CatacombLevelSettings(base.levels.get(i)));
                continue;
            }
            this.levels.put(i, new CatacombLevelSettings(base.levels.get(i), override.levels.get(i)));
        }
    }

    public CatacombSettings(CatacombSettings toCopy) {
        this.depth = toCopy.depth;
        this.levels = new HashMap<Integer, CatacombLevelSettings>();
        for (int i = 0; i < 5; ++i) {
            this.levels.put(i, new CatacombLevelSettings(toCopy.levels.get(i)));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setCriteria(SpawnCriteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public boolean isValid(World world, Coord pos) {
        if (this.criteria == null) {
            return false;
        }
        return this.criteria.isValid(world, pos);
    }

    @Override
    public CatacombLevelSettings getLevelSettings(int level) {
        return this.levels.get(level);
    }

    @Override
    public CatacombTowerSettings getTower() {
        if (this.towerSettings == null) {
            return new CatacombTowerSettings(Tower.ROGUE, Theme.getTheme(Theme.TOWER));
        }
        return this.towerSettings;
    }

    @Override
    public int getNumLevels() {
        if (this.depth < 0) {
            return 0;
        }
        if (this.depth > 5) {
            return 5;
        }
        return this.depth;
    }
}

