/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.treasure.loot.provider.ItemTool;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import greymerk.roguelike.util.TextFormat;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public enum Loot {
    WEAPON,
    ARMOUR,
    BLOCK,
    JUNK,
    ORE,
    TOOL,
    POTION,
    FOOD,
    ENCHANTBOOK,
    ENCHANTBONUS,
    SUPPLY,
    MUSIC,
    SMITHY,
    SPECIAL,
    REWARD;


    public static ItemStack getEquipmentBySlot(Random rand, Slot slot, int level, boolean enchant) {
        if (slot == Slot.WEAPON) {
            return ItemWeapon.getRandom(rand, level, enchant);
        }
        return ItemArmour.getRandom(rand, level, slot, enchant);
    }

    public static int getEnchantLevel(Random rand, int level) {
        switch (level) {
            case 4: {
                return 21 + rand.nextInt(10);
            }
            case 3: {
                return 16 + rand.nextInt(10);
            }
            case 2: {
                return 5 + rand.nextInt(10);
            }
            case 1: {
                return 1 + rand.nextInt(5);
            }
            case 0: {
                return 1;
            }
        }
        return 1;
    }

    public static void enchantItemChance(ItemStack item, Random rand, int level) {
        if (rand.nextInt(7 - level) == 0) {
            Loot.enchantItem(item, rand, Loot.getEnchantLevel(rand, level));
        }
    }

    public static void enchantItem(ItemStack item, Random rand, int enchantLevel) {
        boolean isBook;
        if (item == null) {
            return;
        }
        List enchants = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)item, (int)enchantLevel);
        boolean bl = isBook = item.func_77973_b() == Items.field_151122_aG;
        if (isBook) {
            item.func_150996_a((Item)Items.field_151134_bR);
            if (enchants.size() > 1) {
                enchants.remove(rand.nextInt(enchants.size()));
            }
        }
        for (EnchantmentData toAdd : enchants) {
            if (isBook) {
                Items.field_151134_bR.func_92115_a(item, toAdd);
                continue;
            }
            item.func_77966_a(toAdd.field_76302_b, toAdd.field_76303_c);
        }
    }

    public static void setItemLore(ItemStack item, String loreText) {
        NBTTagCompound display;
        if (item.field_77990_d == null) {
            item.field_77990_d.func_74782_a("tag", (NBTBase)new NBTTagCompound());
        }
        if (!item.field_77990_d.func_74764_b("display")) {
            item.field_77990_d.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(display = item.field_77990_d.func_74775_l("display")).func_74764_b("Lore")) {
            display.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagList lore = display.func_150295_c("Lore", 0);
        NBTTagString toAdd = new NBTTagString(loreText);
        lore.func_74742_a((NBTBase)toAdd);
        display.func_74782_a("Lore", (NBTBase)lore);
    }

    public static void setItemLore(ItemStack item, String loreText, TextFormat option) {
        Loot.setItemLore(item, TextFormat.apply(loreText, option));
    }

    public static void setItemName(ItemStack item, String name, TextFormat option) {
        if (option == null) {
            item.func_151001_c(name);
            return;
        }
        item.func_151001_c(TextFormat.apply(name, option));
    }

    public static void setItemName(ItemStack item, String name) {
        Loot.setItemName(item, name, null);
    }

    public static void addEquipment(World world, int level, Entity mob) {
        boolean enchant;
        if (level > 4) {
            level = 4;
        }
        Random rand = world.field_73012_v;
        EnumDifficulty difficulty = world.field_73013_u;
        if (difficulty == null) {
            difficulty = EnumDifficulty.NORMAL;
        }
        switch (difficulty) {
            case PEACEFUL: {
                enchant = false;
                break;
            }
            case EASY: {
                enchant = rand.nextInt(5) == 0;
                break;
            }
            case NORMAL: {
                enchant = level >= 3 || rand.nextBoolean();
                break;
            }
            case HARD: {
                enchant = true;
                break;
            }
            default: {
                enchant = true;
            }
        }
        if (mob instanceof EntityZombie) {
            ItemStack weapon;
            if (rand.nextInt(20) == 0) {
                ((EntityZombie)mob).func_82227_f(true);
                weapon = rand.nextInt(20) == 0 ? ItemNovelty.getItem(ItemNovelty.ASHLEA) : (rand.nextInt(5) == 0 ? new ItemStack(Items.field_151106_aX) : ItemTool.getRandom(rand, level, enchant));
            } else {
                weapon = ItemTool.getRandom(rand, level, enchant);
            }
            mob.func_70062_b(0, weapon);
        }
        if (mob instanceof EntitySkeleton) {
            if (rand.nextInt(10) == 0 && level > 1) {
                ((EntitySkeleton)mob).func_82201_a(1);
                mob.func_70062_b(0, ItemWeapon.getSword(rand, level, enchant));
            } else if (rand.nextInt(20) == 0) {
                if (level > 0 && rand.nextInt(5) == 0) {
                    mob.func_70062_b(0, ItemNovelty.getItem(ItemNovelty.VALANDRAH));
                }
                mob.func_70062_b(0, ItemWeapon.getSword(rand, level, enchant));
            } else {
                mob.func_70062_b(0, ItemWeapon.getBow(rand, level, enchant));
            }
        }
        for (int i = 1; i < 5; ++i) {
            if (!enchant) continue;
            ItemStack item = Loot.getEquipmentBySlot(rand, Slot.getSlotByNumber(i), level, enchant);
            mob.func_70062_b(i, item);
        }
        for (int s = 0; s < 5; ++s) {
            ((EntityLiving)mob).func_96120_a(s, (float)RogueConfig.getDouble(RogueConfig.LOOTING));
        }
    }
}

