/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.gson.JsonObject;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.JsonNBT;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WeightedRandomLoot
implements Comparable<WeightedRandomLoot>,
IWeighted<ItemStack> {
    private Item item;
    private int damage;
    private int min;
    private int max;
    private int weight;
    private NBTTagCompound nbt;

    public WeightedRandomLoot(Item item, int damage, int minStackSize, int maxStackSize, int weight) {
        this.item = item;
        this.damage = damage;
        this.min = minStackSize;
        this.max = maxStackSize;
        this.weight = weight;
    }

    public WeightedRandomLoot(Item id, int damage, int weight) {
        this(id, damage, 1, 1, weight);
    }

    public WeightedRandomLoot(Item id, int weight) {
        this(id, 0, 1, 1, weight);
    }

    public WeightedRandomLoot(JsonObject json, int weight) {
        String name = json.get("name").getAsString();
        this.item = (Item)Item.field_150901_e.func_82594_a(name);
        this.damage = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.weight = weight;
        if (json.has("min") && json.has("max")) {
            this.min = json.get("min").getAsInt();
            this.max = json.get("max").getAsInt();
        } else {
            this.min = 1;
            this.max = 1;
        }
        if (json.has("nbt")) {
            JsonObject nbtdata = json.get("nbt").getAsJsonObject();
            this.nbt = JsonNBT.jsonToCompound(nbtdata);
        }
    }

    public WeightedRandomLoot(Block block, int i) {
        this(Item.func_150899_d((int)Block.func_149682_b((Block)block)), i);
    }

    private int getStackSize(Random rand) {
        if (this.max == 1) {
            return 1;
        }
        return rand.nextInt(this.max - this.min) + this.min;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public ItemStack get(Random rand) {
        ItemStack item = new ItemStack(this.item, this.getStackSize(rand), this.damage);
        if (this.nbt != null) {
            item.func_77982_d(this.nbt);
        }
        return item;
    }

    @Override
    public int compareTo(WeightedRandomLoot other) {
        if (this.weight > other.weight) {
            return -1;
        }
        if (this.weight < other.weight) {
            return 1;
        }
        return 0;
    }
}

