/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class Furnace {
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;

    public static void generate(World world, Cardinal dir, Coord pos) {
        Furnace.generate(world, null, false, dir, pos);
    }

    public static void generate(World world, boolean lit, Cardinal dir, Coord pos) {
        Furnace.generate(world, null, lit, dir, pos);
    }

    public static void generate(World world, ItemStack fuel, boolean lit, Cardinal dir, Coord pos) {
        if (lit ? !WorldGenPrimitive.setBlock(world, pos, Blocks.field_150470_am) : !WorldGenPrimitive.setBlock(world, pos, Blocks.field_150460_al)) {
            return;
        }
        int meta = 0;
        switch (dir) {
            case NORTH: {
                meta = 2;
                break;
            }
            case SOUTH: {
                meta = 3;
                break;
            }
            case WEST: {
                meta = 4;
                break;
            }
            case EAST: {
                meta = 5;
            }
        }
        world.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), meta, 2);
        if (fuel == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
        if (te == null) {
            return;
        }
        if (!(te instanceof TileEntityFurnace)) {
            return;
        }
        TileEntityFurnace furnace = (TileEntityFurnace)te;
        furnace.func_70299_a(1, fuel);
    }
}

