/*
 * Decompiled with CFR 0.152.
 */
package io.nettyopis.channel;

import io.nettyopis.channel.AbstractChannelHandlerContext;
import io.nettyopis.channel.ChannelHandler;
import io.nettyopis.channel.ChannelInboundHandler;
import io.nettyopis.channel.ChannelOutboundHandler;
import io.nettyopis.channel.DefaultChannelPipeline;
import io.nettyopis.util.concurrent.EventExecutorGroup;

final class DefaultChannelHandlerContext
extends AbstractChannelHandlerContext {
    private final ChannelHandler handler;

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, EventExecutorGroup group, String name, ChannelHandler handler) {
        super(pipeline, group, name, DefaultChannelHandlerContext.isInbound(handler), DefaultChannelHandlerContext.isOutbound(handler));
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = handler;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    private static boolean isInbound(ChannelHandler handler) {
        return handler instanceof ChannelInboundHandler;
    }

    private static boolean isOutbound(ChannelHandler handler) {
        return handler instanceof ChannelOutboundHandler;
    }
}

