/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import java.util.Collection;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.event.ComponentEvent;

public abstract class UIListContainer<T extends UIListContainer, S>
extends UIComponent<T> {
    protected int elementSpacing = 0;
    protected boolean unselect = true;
    protected Collection<S> elements;
    protected S hovered;
    protected S selected;
    protected S current;

    public UIListContainer(MalisisGui gui) {
        super(gui);
    }

    public UIListContainer(MalisisGui gui, int width, int height) {
        super(gui);
        this.setSize(width, height);
    }

    public void setElements(Collection<S> elements) {
        this.elements = elements;
    }

    public Iterable<S> getElements() {
        return this.elements;
    }

    public void setElementSpacing(int elementSpacing) {
        this.elementSpacing = elementSpacing;
    }

    public boolean canUnselect() {
        return this.unselect;
    }

    public void setUnselect(boolean unselect) {
        this.unselect = unselect;
    }

    public void setSelected(S comp) {
        this.selected = comp;
    }

    public S getSelected() {
        return this.selected;
    }

    public boolean isSelected(S element) {
        return element == this.selected;
    }

    public S select(S element) {
        if (!this.fireEvent(new SelectEvent<S>(this, element))) {
            return this.getSelected();
        }
        this.setSelected(element);
        return element;
    }

    @Override
    public UIComponent getComponentAt(int x, int y) {
        this.hovered = null;
        UIComponent c = super.getComponentAt(x, y);
        if (c != this) {
            return c;
        }
        int ey = 0;
        int cy = this.relativeY(y);
        for (S element : this.elements) {
            int h = this.getElementHeight(element);
            if (ey + h > cy) {
                this.hovered = element;
                return this;
            }
            ey += h;
        }
        return this;
    }

    @Override
    public boolean onClick(int x, int y) {
        if (!(this.canUnselect() || this.hovered != null && this.hovered != this.getSelected())) {
            return super.onClick(x, y);
        }
        if (this.hovered == this.getSelected()) {
            this.hovered = null;
        }
        this.select(this.hovered);
        return true;
    }

    @Override
    public void draw(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.elements.size() == 0) {
            this.drawEmtpy(renderer, mouseX, mouseY, partialTick);
            return;
        }
        int bk = this.y;
        for (S element : this.elements) {
            this.current = element;
            super.draw(renderer, mouseX, mouseY, partialTick);
            this.y += this.getElementHeight(element) + this.elementSpacing;
        }
        this.y = bk;
    }

    public abstract int getElementHeight(S var1);

    public abstract void drawEmtpy(GuiRenderer var1, int var2, int var3, float var4);

    public static class SelectEvent<T>
    extends ComponentEvent.ValueChange<UIListContainer, T> {
        public SelectEvent(UIListContainer component, T selected) {
            super(component, component.getSelected(), selected);
        }

        public T getSelected() {
            return (T)this.newValue;
        }
    }
}

