/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweaks.config;

import iguanaman.iguanatweaks.IguanaTweaks;
import iguanaman.iguanatweaks.config.IguanaConfig;
import iguanaman.iguanatweaks.util.IguanaJsonReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class IguanaWeightsConfig {
    private static HashMap<String, Double> weights;

    public static void init(File file) {
        if (file.exists()) {
            weights = IguanaJsonReader.readWeightsJson(file);
        } else {
            try {
                if (file.createNewFile()) {
                    PrintWriter writer = new PrintWriter(file);
                    writer.println("[");
                    writer.println("]");
                    writer.close();
                }
            }
            catch (IOException e) {
                IguanaTweaks.log.error("There was an error in creating the weights.json file");
                e.printStackTrace();
            }
        }
    }

    public static double getWeight(ItemStack stack) {
        if (weights != null && stack.func_77973_b() != null && Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) != null && weights.containsKey(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()))) {
            return weights.get(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        }
        return IguanaWeightsConfig.getDefaultWeight(stack);
    }

    private static double getDefaultWeight(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return IguanaConfig.itemWeight;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Material blockMaterial = block.func_149688_o();
        if (blockMaterial == Material.field_151573_f || blockMaterial == Material.field_151574_g) {
            return 1.5;
        }
        if (blockMaterial == Material.field_151576_e) {
            return 1.0;
        }
        if (blockMaterial == Material.field_151577_b || blockMaterial == Material.field_151578_c || blockMaterial == Material.field_151595_p || blockMaterial == Material.field_151597_y || blockMaterial == Material.field_151575_d || blockMaterial == Material.field_151592_s || blockMaterial == Material.field_151588_w || blockMaterial == Material.field_151590_u) {
            return 0.5;
        }
        if (blockMaterial == Material.field_151580_n) {
            return 0.25;
        }
        return 0.0625;
    }
}

