/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweaks.events;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import iguanaman.iguanatweaks.IguanaTweaks;
import iguanaman.iguanatweaks.config.IguanaConfig;
import iguanaman.iguanatweaks.config.IguanaWeightsConfig;
import iguanaman.iguanatweaks.data.EntityData;
import iguanaman.iguanatweaks.util.IguanaUtils;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.lwjgl.opengl.GL11;

public class IguanaEventHook {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        if (world.field_72995_K && entity != null) {
            double speedModifier = 1.0;
            boolean isCreative = false;
            if (entity instanceof EntityPlayer) {
                int delay;
                EntityPlayer player = (EntityPlayer)entity;
                if (entity.func_70654_ax() % IguanaConfig.tickRateEntityUpdate == 0 && IguanaConfig.increasedStepHeight) {
                    player.field_70138_W = 1.0f;
                }
                if (player.field_71075_bZ.field_75098_d) {
                    isCreative = true;
                }
                NBTTagCompound tags = player.getEntityData();
                if (IguanaConfig.hideHealthBar) {
                    if (player.func_110143_aJ() >= (float)IguanaConfig.hideHealthBarThreshold) {
                        delay = tags.func_74762_e("HideHealthBarDelay");
                        if (delay >= IguanaConfig.hideHealthBarDelay * 20) {
                            GuiIngameForge.renderHealth = false;
                        } else {
                            tags.func_74768_a("HideHealthBarDelay", ++delay);
                        }
                    } else {
                        tags.func_82580_o("HideHealthBarDelay");
                        GuiIngameForge.renderHealth = true;
                    }
                }
                if (IguanaConfig.hideHungerBar) {
                    if (player.func_71024_bL().func_75116_a() >= IguanaConfig.hideHungerBarThreshold) {
                        delay = tags.func_74762_e("HideHungerBarDelay");
                        if (delay >= IguanaConfig.hideHungerBarDelay * 20) {
                            GuiIngameForge.renderFood = false;
                        } else {
                            tags.func_74768_a("HideHungerBarDelay", ++delay);
                        }
                    } else {
                        tags.func_82580_o("HideHungerBarDelay");
                        GuiIngameForge.renderFood = true;
                    }
                }
                if (IguanaConfig.hideHotbar) {
                    delay = tags.func_74762_e("HideHotbarDelay");
                    if (delay >= IguanaConfig.hideHotbarDelay * 20) {
                        GuiIngameForge.renderHotbar = false;
                    } else {
                        tags.func_74768_a("HideHotbarDelay", ++delay);
                        GuiIngameForge.renderHotbar = true;
                    }
                }
            }
            if (IguanaTweaks.entityDataMap.containsKey(entity.func_110124_au())) {
                if (IguanaTweaks.entityDataMap.get(entity.func_110124_au()) != null) {
                    speedModifier = IguanaTweaks.entityDataMap.get((Object)entity.func_110124_au()).speedModifier;
                } else {
                    IguanaTweaks.log.error("There's an entry in entityDataMap == null. That's bad.");
                }
            } else {
                double slownessWeight = 0.0;
                double slownessArmour = (double)entity.func_70658_aO() * IguanaConfig.armorWeight;
                double weight = 0.0;
                double maxWeight = 0.0;
                if (!isCreative) {
                    int slownessHurt = 0;
                    int slownessTerrain = 0;
                    boolean onIce = false;
                    PotionEffect currentEffect = entity.func_70660_b(IguanaTweaks.slowdownNew);
                    if (currentEffect != null) {
                        slownessHurt += Math.round(100.0f * ((float)currentEffect.func_76459_b() / (float)currentEffect.func_76458_c()));
                    }
                    if (!entity.func_70090_H() && IguanaConfig.terrainSlowdownPercentage > 0) {
                        double posmod = 0.0;
                        if (entity instanceof EntityClientPlayerMP) {
                            posmod = 1.62;
                        }
                        int posX = (int)entity.field_70165_t;
                        int posY = (int)(entity.field_70163_u - posmod - 1.0);
                        int posZ = (int)entity.field_70161_v;
                        if (posX < 0) {
                            --posX;
                        }
                        if (posY < 0) {
                            --posY;
                        }
                        if (posZ < 0) {
                            --posZ;
                        }
                        Material blockOnMaterial = world.func_147439_a(posX, posY, posZ).func_149688_o();
                        Material blockInMaterial = world.func_147439_a(posX, posY + 1, posZ).func_149688_o();
                        if (blockOnMaterial == Material.field_151577_b || blockOnMaterial == Material.field_151578_c) {
                            slownessTerrain = IguanaConfig.terrainSlowdownOnDirt;
                        } else if (blockOnMaterial == Material.field_151595_p) {
                            slownessTerrain = IguanaConfig.terrainSlowdownOnSand;
                        } else if (blockOnMaterial == Material.field_151584_j || blockOnMaterial == Material.field_151585_k || blockOnMaterial == Material.field_151582_l) {
                            slownessTerrain = IguanaConfig.terrainSlowdownOnPlant;
                        } else if (blockOnMaterial == Material.field_151588_w) {
                            slownessTerrain = IguanaConfig.terrainSlowdownOnIce;
                        } else if (blockOnMaterial == Material.field_151597_y) {
                            slownessTerrain = IguanaConfig.terrainSlowdownOnSnow;
                        }
                        if (blockInMaterial == Material.field_151597_y) {
                            slownessTerrain += IguanaConfig.terrainSlowdownInSnow;
                        } else if (blockInMaterial == Material.field_151582_l || blockOnMaterial == Material.field_151585_k) {
                            slownessTerrain += IguanaConfig.terrainSlowdownInPlant;
                        }
                        if (blockOnMaterial == Material.field_151588_w) {
                            onIce = true;
                        }
                        slownessTerrain = Math.round((float)slownessTerrain * ((float)IguanaConfig.terrainSlowdownPercentage / 100.0f));
                    }
                    if (entity instanceof EntityPlayer && IguanaConfig.maxCarryWeight > 0) {
                        EntityPlayer player = (EntityPlayer)entity;
                        for (Object slotObject : player.field_71069_bz.field_75151_b) {
                            Slot slot = (Slot)slotObject;
                            if (!slot.func_75216_d()) continue;
                            ItemStack stack = slot.func_75211_c();
                            double toAdd = IguanaWeightsConfig.getWeight(stack);
                            if (stack.func_77973_b() instanceof ItemBlock) {
                                toAdd *= IguanaConfig.rockWeight;
                            }
                            weight += toAdd * (double)stack.field_77994_a;
                        }
                        maxWeight = IguanaConfig.maxCarryWeight;
                        slownessWeight = weight / maxWeight * 100.0;
                        if (slownessWeight > 0.0) {
                            player.func_71020_j(1.0E-4f * (float)Math.round(slownessWeight));
                        }
                    }
                    if (slownessArmour > 100.0) {
                        slownessArmour = 100.0;
                    }
                    if (slownessHurt > 100) {
                        slownessHurt = 100;
                    }
                    if (slownessTerrain > 100) {
                        slownessTerrain = 100;
                    }
                    if (slownessWeight > 100.0) {
                        slownessWeight = 100.0;
                    }
                    double speedModifierArmour = (100.0 - slownessArmour) / 100.0;
                    double speedModifierHurt = (100.0 - (double)slownessHurt) / 100.0;
                    double speedModifierTerrain = (100.0 - (double)slownessTerrain) / 100.0;
                    double speedModifierWeight = (100.0 - slownessWeight) / 100.0;
                    speedModifier = speedModifierArmour * speedModifierHurt * speedModifierTerrain * speedModifierWeight;
                    if (entity instanceof EntityPlayerSP) {
                        EntityPlayerSP playerSP = (EntityPlayerSP)entity;
                        if (playerSP.field_70701_bs < 0.0f) {
                            speedModifier *= 0.5;
                        }
                    }
                    if (onIce) {
                        speedModifier = 0.8 + speedModifier / 5.0;
                    }
                }
                EntityData entityData = new EntityData(speedModifier, weight, maxWeight, slownessWeight, slownessArmour);
                IguanaTweaks.entityDataMap.put(entity.func_110124_au(), entityData);
            }
            if (speedModifier != 1.0 && !IguanaUtils.isJumping(entity)) {
                speedModifier = 2.0 * speedModifier - 1.0;
                entity.field_70159_w *= speedModifier;
                entity.field_70179_y *= speedModifier;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void LivingDrops(LivingDropsEvent event) {
        if (event.entityLiving != null) {
            boolean isPlayer = event.entityLiving instanceof EntityPlayer;
            if (IguanaConfig.restrictedDrops.size() > 0 || IguanaConfig.itemLifespanPlayerDeath != 6000 && isPlayer || IguanaConfig.itemLifespanMobDeath != 6000 && !isPlayer) {
                Iterator i = event.drops.iterator();
                while (i.hasNext()) {
                    EntityItem eitem = (EntityItem)i.next();
                    if (eitem == null || eitem.func_92059_d() == null) continue;
                    ItemStack item = eitem.func_92059_d();
                    if (!isPlayer && (IguanaConfig.restrictedDrops.contains(Item.field_150901_e.func_148750_c((Object)item)) || IguanaConfig.restrictedDrops.contains(Item.field_150901_e.func_148750_c((Object)item) + ":" + Integer.toString(item.func_77960_j())))) {
                        i.remove();
                        continue;
                    }
                    if (IguanaConfig.itemLifespanPlayerDeath != 6000 && isPlayer) {
                        eitem.lifespan = IguanaConfig.itemLifespanPlayerDeath;
                        continue;
                    }
                    if (IguanaConfig.itemLifespanMobDeath == 6000 || isPlayer) continue;
                    eitem.lifespan = IguanaConfig.itemLifespanMobDeath;
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemTossEvent(ItemTossEvent event) {
        if (event.entityItem != null) {
            event.entityItem.lifespan = IguanaConfig.itemLifespanTossed;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (IguanaConfig.maxCarryWeight > 0 || IguanaConfig.armorWeight > 0.0) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            if (IguanaConfig.showCreativeText && !mc.field_71474_y.field_74330_P && player.field_71075_bZ.field_75098_d) {
                event.left.add(I18n.func_135052_a((String)"gameMode.creative", (Object[])new Object[0]));
            }
            if (IguanaTweaks.entityDataMap.containsKey(player.func_110124_au())) {
                EntityData playerWeightValues = IguanaTweaks.entityDataMap.get(player.func_110124_au());
                if (mc.field_71474_y.field_74330_P && IguanaConfig.addEncumbranceDebugText) {
                    event.left.add("");
                    event.left.add(I18n.func_135052_a((String)"hud.weight", (Object[])new Object[0]) + ": " + String.format("%.2f", playerWeightValues.currentWeight) + " / " + String.format("%.2f", playerWeightValues.maxWeight) + " (" + String.format("%.2f", playerWeightValues.encumberance) + "%)");
                } else if (!player.field_70128_L && !player.field_71075_bZ.field_75098_d && IguanaConfig.addEncumbranceHudText) {
                    String color = "\u00a7f";
                    String line = "";
                    if (IguanaConfig.detailedEncumbranceHudText) {
                        if (playerWeightValues.encumberance >= 30.0) {
                            color = "\u00a74";
                        } else if (playerWeightValues.encumberance >= 20.0) {
                            color = "\u00a76";
                        } else if (playerWeightValues.encumberance >= 10.0) {
                            color = "\u00a7e";
                        }
                        line = I18n.func_135052_a((String)"hud.weight", (Object[])new Object[0]) + ": " + Double.toString(Math.round(playerWeightValues.currentWeight)) + " / " + Double.toString(Math.round(playerWeightValues.maxWeight)) + " (" + String.format("%.2f", playerWeightValues.encumberance) + "%)";
                    } else {
                        double totalEncumberance = playerWeightValues.encumberance + playerWeightValues.armour;
                        if (totalEncumberance >= 30.0) {
                            color = "\u00a74";
                        } else if (totalEncumberance >= 20.0) {
                            color = "\u00a76";
                        } else if (totalEncumberance >= 10.0) {
                            color = "\u00a7e";
                        }
                        if (totalEncumberance >= 30.0) {
                            line = I18n.func_135052_a((String)"hud.encumberance.greatly", (Object[])new Object[0]);
                        } else if (totalEncumberance >= 20.0) {
                            line = I18n.func_135052_a((String)"hud.encumberance.average", (Object[])new Object[0]);
                        } else if (totalEncumberance >= 10.0) {
                            line = I18n.func_135052_a((String)"hud.encumberance.slightly", (Object[])new Object[0]);
                        }
                    }
                    if (!line.equals("")) {
                        event.right.add(color + line + "\u00a7r");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void playerSleep(PlayerSleepInBedEvent event) {
        if (IguanaConfig.disableSleeping) {
            event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
            if (IguanaConfig.disableSettingSpawn) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.decorativeBeds", new Object[0]));
            } else {
                event.entityPlayer.setSpawnChunk(new ChunkCoordinates(event.x, event.y, event.z), false, event.entityPlayer.field_70170_p.field_73011_w.field_76574_g);
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.setNoSleep", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        if (IguanaConfig.disableCoalGen && event.type == OreGenEvent.GenerateMinable.EventType.COAL || IguanaConfig.disableDiamondGen && event.type == OreGenEvent.GenerateMinable.EventType.DIAMOND || IguanaConfig.disableDirtGen && event.type == OreGenEvent.GenerateMinable.EventType.DIRT || IguanaConfig.disableGoldGen && event.type == OreGenEvent.GenerateMinable.EventType.GOLD || IguanaConfig.disableGravelGen && event.type == OreGenEvent.GenerateMinable.EventType.GRAVEL || IguanaConfig.disableIronGen && event.type == OreGenEvent.GenerateMinable.EventType.IRON || IguanaConfig.disableLapisGen && event.type == OreGenEvent.GenerateMinable.EventType.LAPIS || IguanaConfig.disableRedstoneGen && event.type == OreGenEvent.GenerateMinable.EventType.REDSTONE) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.entity != null) {
            if (event.entity instanceof EntityItem) {
                EntityItem item = (EntityItem)event.entity;
                if (item.lifespan != 6000 && IguanaConfig.itemLifespan != 6000) {
                    item.lifespan = IguanaConfig.itemLifespan;
                }
            } else if (event.entity instanceof EntityXPOrb) {
                EntityXPOrb orb = (EntityXPOrb)event.entity;
                if (IguanaConfig.itemLifespanXp != 6000) {
                    orb.field_70531_b = 6000 - IguanaConfig.itemLifespanXp;
                }
                if (IguanaConfig.experiencePercentageAll != 100) {
                    orb.field_70530_e = Math.round((float)orb.field_70530_e * ((float)IguanaConfig.experiencePercentageAll / 100.0f));
                    if (orb.field_70530_e == 0) {
                        orb.field_70531_b = 6000;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        if (IguanaConfig.experiencePercentageOre != 100) {
            event.setExpToDrop(Math.round((float)event.getExpToDrop() * ((float)IguanaConfig.experiencePercentageOre / 100.0f)));
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (IguanaConfig.hardnessMultiplier != 1.0 && event.entityPlayer != null && event.block != null && (IguanaConfig.hardnessBlockListIsWhitelist && IguanaConfig.hardnessBlockList.contains(Block.field_149771_c.func_148750_c((Object)event.block)) || !IguanaConfig.hardnessBlockListIsWhitelist && !IguanaConfig.hardnessBlockList.contains(Block.field_149771_c.func_148750_c((Object)event.block)))) {
            event.newSpeed = IguanaConfig.hardnessMultiplier == 0.0 ? Float.MAX_VALUE : event.originalSpeed / (float)IguanaConfig.hardnessMultiplier;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (event.dwheel != 0) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound tags = player.getEntityData();
            tags.func_82580_o("HideHotbarDelay");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            int guiHeight = 39;
            if (!GuiIngameForge.renderExperiance) {
                guiHeight -= 5;
            }
            if (!GuiIngameForge.renderHotbar) {
                guiHeight -= 22;
            }
            GuiIngameForge.left_height = GuiIngameForge.right_height = guiHeight;
        }
        if (IguanaConfig.hideHungerBar && event.type.equals((Object)RenderGameOverlayEvent.ElementType.FOOD)) {
            EntityClientPlayerMP player = mc.field_71439_g;
            NBTTagCompound tags = player.getEntityData();
            if (tags.func_74762_e("HideHungerBarDelay") >= IguanaConfig.hideHungerBarDelay * 20) {
                event.setCanceled(true);
            }
        } else if (IguanaConfig.hideHotbarBackground && event.type.equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && !event.isCanceled()) {
            GuiIngame g = mc.field_71456_v;
            int width = event.resolution.func_78326_a();
            int height = event.resolution.func_78328_b();
            mc.field_71424_I.func_76320_a("actionBar");
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(new ResourceLocation("textures/gui/widgets.png"));
            InventoryPlayer inv = mc.field_71439_g.field_71071_by;
            g.func_73729_b(width / 2 - 91 - 1 + inv.field_70461_c * 20, height - 22 - 1, 0, 22, 24, 22);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            for (int i = 0; i < 9; ++i) {
                int x = width / 2 - 90 + i * 20 + 2;
                int z = height - 16 - 3;
                g.func_73832_a(i, x, z, event.partialTicks);
            }
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            mc.field_71424_I.func_76319_b();
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!IguanaConfig.disableWeightsTooltip && event.showAdvancedItemTooltips) {
            event.toolTip.add(I18n.func_135052_a((String)"hud.weight", (Object[])new Object[0]) + ": " + IguanaWeightsConfig.getWeight(event.itemStack));
        }
    }
}

