/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweaks.util;

import cpw.mods.fml.common.registry.GameRegistry;
import iguanaman.iguanatweaks.IguanaTweaks;
import iguanaman.iguanatweaks.config.IguanaConfig;
import iguanaman.iguanatweaks.config.IguanaWeightsConfig;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class StackSizeTweaks {
    public static void init() {
        IguanaTweaks.log.info("Reducing stack sizes");
        boolean doBlocks = IguanaConfig.blockStackSizeDividerMax > 1;
        boolean doItems = IguanaConfig.itemStackSizeDivider > 1;
        for (Object obj : Item.field_150901_e) {
            int size;
            float weight;
            ItemStack stack;
            if (obj instanceof ItemBlock && doBlocks) {
                Block block = ((ItemBlock)obj).field_150939_a;
                stack = new ItemStack(block);
                weight = (float)IguanaWeightsConfig.getWeight(stack);
                size = 0;
                if (weight > 0.0f) {
                    size = Math.round((float)stack.func_77973_b().getItemStackLimit(stack) / ((float)IguanaConfig.blockStackSizeDividerMax * weight));
                    if (size > stack.func_77973_b().getItemStackLimit(stack) / IguanaConfig.blockStackSizeDividerMin) {
                        size = stack.func_77973_b().getItemStackLimit(stack) / IguanaConfig.blockStackSizeDividerMin;
                    }
                } else {
                    size = Math.round((float)stack.func_77973_b().getItemStackLimit(stack) / (float)IguanaConfig.blockStackSizeDividerMin);
                }
                if (size < 1) {
                    size = 1;
                } else if (size > 64) {
                    size = 64;
                }
                if (size < stack.func_77973_b().getItemStackLimit(stack)) {
                    stack.func_77973_b().func_77625_d(size);
                }
                if (!IguanaConfig.logStackSizeChanges) continue;
                IguanaTweaks.log.info("Reduced stack size of block " + GameRegistry.findUniqueIdentifierFor((Block)block).toString() + " to " + size);
                continue;
            }
            if (!doItems) continue;
            Item item = (Item)obj;
            stack = new ItemStack(item);
            weight = (float)IguanaWeightsConfig.getWeight(stack);
            size = 0;
            size = weight > 0.0f ? Math.round((float)item.getItemStackLimit(stack) / ((float)IguanaConfig.itemStackSizeDivider * weight)) : Math.round((float)item.getItemStackLimit(stack) / (float)IguanaConfig.itemStackSizeDivider);
            if (size < 1) {
                size = 1;
            } else if (size > 64) {
                size = 64;
            }
            if (size < item.getItemStackLimit(stack)) {
                item.func_77625_d(size);
            }
            if (!IguanaConfig.logStackSizeChanges) continue;
            IguanaTweaks.log.info("Reduced stack size of item " + GameRegistry.findUniqueIdentifierFor((Item)item).toString() + " to " + size);
        }
    }
}

