/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import hardcorequesting.EventHandler;
import hardcorequesting.HQMTab;
import hardcorequesting.PlayerDeathEventListener;
import hardcorequesting.PlayerTracker;
import hardcorequesting.WorldEventListener;
import hardcorequesting.blocks.ModBlocks;
import hardcorequesting.commands.CommandHandler;
import hardcorequesting.config.ConfigHandler;
import hardcorequesting.items.ModItems;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.proxies.CommonProxy;
import hardcorequesting.quests.Quest;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="HardcoreQuesting", name="Hardcore Questing Mode", version="The Journey (4.2.2)")
public class HardcoreQuesting {
    @Mod.Instance(value="HardcoreQuesting")
    public static HardcoreQuesting instance;
    @SidedProxy(clientSide="hardcorequesting.proxies.ClientProxy", serverSide="hardcorequesting.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs HQMTab;
    public static String path;
    public static Configuration config;
    public static FMLEventChannel packetHandler;
    private static final String EDITOR_KEY = "UseEditor";
    private static final boolean EDITOR_DEFAULT = false;
    private static final String EDITOR_COMMENT = "Only use this as a map maker who wants to create quests. Leaving this off allows you the play the existing quests.";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new EventHandler();
        packetHandler = NetworkRegistry.INSTANCE.newEventDrivenChannel("hcQuesting");
        path = event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "hqm".toLowerCase() + File.separator;
        ConfigHandler.init(path);
        proxy.init();
        proxy.initRenderers();
        proxy.initSounds(path);
        ModItems.init();
        ModBlocks.init();
        ModBlocks.registerBlocks();
        ModBlocks.registerTileEntities();
        config = new Configuration(new File(path + "editmode.cfg"));
        HardcoreQuesting.syncEdit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)instance);
        packetHandler.register((Object)new PacketHandler());
        new WorldEventListener();
        new PlayerDeathEventListener();
        new PlayerTracker();
        ModItems.registerRecipes();
        ModBlocks.registerRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Quest.init(path);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerStoppingEvent event) {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("HardcoreQuesting")) {
            HardcoreQuesting.syncEdit();
        }
    }

    public static void syncEdit() {
        Quest.isEditing = config.get("general", EDITOR_KEY, false, EDITOR_COMMENT).getBoolean(false);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        HQMTab = new HQMTab(CreativeTabs.getNextID(), "Hardcore Questing Mode");
    }
}

