/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import hardcorequesting.QuestingData;
import hardcorequesting.commands.CommandHandler;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.Quest;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public final class OPBookHelper {
    private OPBookHelper() {
    }

    public static void handlePacket(EntityPlayer player, DataReader dr) {
        if (CommandHandler.isOwnerOrOp((ICommandSender)player)) {
            OpAction action = OpAction.values()[dr.readData(DataBitHelper.OP_ACTION)];
            switch (action) {
                case RESET: {
                    QuestingData.getQuestingData(player).getTeam().clearProgress();
                    break;
                }
                case QUEST_COMPLETION: {
                    Quest quest = Quest.getQuest(dr.readData(DataBitHelper.QUESTS));
                    if (quest == null) break;
                    if (quest.isCompleted(player)) {
                        QuestingData.getQuestingData(player).getTeam().resetProgress(quest);
                    } else {
                        quest.completeQuest(player);
                    }
                    quest.sendUpdatedDataToTeam(player);
                }
            }
        }
    }

    private static DataWriter getWriter(OpAction action) {
        DataWriter dw = PacketHandler.getWriter(PacketId.OP_BOOK);
        dw.writeData(action.ordinal(), DataBitHelper.OP_ACTION);
        return dw;
    }

    public static void reverseQuestCompletion(Quest quest, EntityPlayer player) {
        DataWriter dw = OPBookHelper.getWriter(OpAction.QUEST_COMPLETION);
        dw.writeData((int)quest.getId(), DataBitHelper.QUESTS);
        PacketHandler.sendToServer(dw);
    }

    public static void reset(EntityPlayer player) {
        PacketHandler.sendToServer(OPBookHelper.getWriter(OpAction.RESET));
    }

    private static enum OpAction {
        RESET,
        QUEST_COMPLETION;

    }
}

