/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.SaveHelper;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.quests.Quest;
import hardcorequesting.reputation.Reputation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuReputationReward
extends GuiEditMenuExtended {
    private List<Quest.ReputationReward> rewards = new ArrayList<Quest.ReputationReward>();
    private Quest.ReputationReward selectedReward;
    private static final int START_X = 20;
    private static final int START_Y = 50;
    private static final int ERROR_Y = 20;
    private static final int OFFSET = 15;
    private List<String> error;

    public GuiEditMenuReputationReward(GuiBase gui, EntityPlayer player, List<Quest.ReputationReward> rewards) {
        super(gui, player, true, 185, 25, 185, 55);
        if (rewards != null) {
            for (Quest.ReputationReward reward : rewards) {
                this.rewards.add(new Quest.ReputationReward(reward.getReputation(), reward.getValue()));
            }
        }
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber(gui, 0, "Reward value"){

            @Override
            protected int getValue() {
                return GuiEditMenuReputationReward.this.selectedReward.getValue();
            }

            @Override
            protected void setValue(int number) {
                GuiEditMenuReputationReward.this.selectedReward.setValue(number);
            }

            @Override
            protected boolean isVisible() {
                return GuiEditMenuReputationReward.this.selectedReward != null;
            }

            @Override
            protected boolean isNegativeAllowed() {
                return true;
            }
        });
        this.buttons.add(new LargeButton("Create new", 20, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuReputationReward.this.rewards.size() < DataBitHelper.REPUTATION_REWARD.getMaximum();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuReputationReward.this.isValid();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuReputationReward.this.rewards.add(new Quest.ReputationReward(Reputation.getReputationList().get(0), 0));
            }
        });
        this.buttons.add(new LargeButton("Delete", 80, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuReputationReward.this.isValid() && GuiEditMenuReputationReward.this.selectedReward != null;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuReputationReward.this.rewards.remove(GuiEditMenuReputationReward.this.selectedReward);
                GuiEditMenuReputationReward.this.selectedReward = null;
            }
        });
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        if (this.isValid()) {
            for (int i = 0; i < this.rewards.size(); ++i) {
                String str = this.rewards.get(i).getLabel();
                boolean hover = gui.inBounds(20, 50 + i * 15, gui.getStringWidth(str), 9, mX, mY);
                boolean selected = this.rewards.get(i).equals(this.selectedReward);
                gui.drawString(str, 20, 50 + i * 15, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
            }
        } else {
            if (this.error == null) {
                this.error = gui.getLinesFromText("There are no valid reputations to choose from. Please go to the reputation menu (click on the reputation button on the left hand side of the book when browsing the main menu) and create at least one first.", 0.7f, 140);
            }
            gui.drawString(this.error, 20, 20, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.isValid()) {
            for (int i = 0; i < this.rewards.size(); ++i) {
                if (!gui.inBounds(20, 50 + i * 15, gui.getStringWidth(this.rewards.get(i).getLabel()), 9, mX, mY)) continue;
                if (this.rewards.get(i).equals(this.selectedReward)) {
                    this.selectedReward = null;
                    break;
                }
                this.selectedReward = this.rewards.get(i);
                this.textBoxes.textBoxes.get(0).reloadText(gui);
                break;
            }
        }
    }

    private boolean isValid() {
        return !Reputation.getReputationList().isEmpty();
    }

    @Override
    protected boolean isArrowVisible() {
        return this.isValid() && this.selectedReward != null;
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (this.selectedReward != null && this.selectedReward.getReputation() != null) {
            for (int i = 0; i < Reputation.getReputationList().size(); ++i) {
                if (!Reputation.getReputationList().get(i).equals(this.selectedReward.getReputation())) continue;
                int id = i + (left ? -1 : 1);
                if (id < 0) {
                    id = Reputation.getReputationList().size() - 1;
                } else if (id >= Reputation.getReputationList().size()) {
                    id = 0;
                }
                this.selectedReward.setReputation(Reputation.getReputationList().get(id));
                break;
            }
        }
    }

    @Override
    protected String getArrowText() {
        return this.selectedReward.getReputation().getName();
    }

    @Override
    protected String getArrowDescription() {
        return null;
    }

    @Override
    protected void save(GuiBase gui) {
        ((GuiQuestBook)gui).getSelectedQuest().setReputationRewards(this.rewards.isEmpty() ? null : this.rewards);
        SaveHelper.add(SaveHelper.EditType.REPUTATION_REWARD_CHANGE);
    }
}

