/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuTracker;
import hardcorequesting.client.interfaces.GuiWrapperEditMenu;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.Quest;
import hardcorequesting.tileentity.TrackerType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityTracker
extends TileEntity {
    private Quest quest;
    private int questId = -1;
    private int radius;
    private TrackerType type = TrackerType.TEAM;
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_RADIUS = "Radius";
    private static final String NBT_TYPE = "TrackerType";
    private int delay = 0;

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.quest != null) {
            compound.func_74777_a(NBT_QUEST, this.quest.getId());
        }
        compound.func_74768_a(NBT_RADIUS, this.radius);
        compound.func_74774_a(NBT_TYPE, (byte)this.type.ordinal());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_QUEST)) {
            this.questId = compound.func_74765_d(NBT_QUEST);
        } else {
            this.quest = null;
        }
        this.radius = compound.func_74762_e(NBT_RADIUS);
        this.type = TrackerType.values()[compound.func_74771_c(NBT_TYPE)];
    }

    public void func_145845_h() {
        if (this.quest == null && this.questId != -1) {
            this.quest = Quest.getQuest(this.questId);
            this.questId = -1;
        }
        if (!this.field_145850_b.field_72995_K && this.delay++ == 20) {
            if (this.quest != null && Quest.getQuest(this.quest.getId()) == null) {
                this.quest = null;
            }
            int oldMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int meta = 0;
            if (this.quest != null) {
                meta = this.type.getMeta(this, this.quest, this.radius);
            }
            if (oldMeta != meta) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 3);
                this.notifyUpdate(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2);
            }
            this.delay = 0;
        }
    }

    private void notifyUpdate(int x, int y, int z, int i) {
        if (i == 2 || x != this.field_145851_c || y != this.field_145848_d || z != this.field_145849_e) {
            this.field_145850_b.func_147460_e(x, y, z, this.func_145838_q());
            if (i > 0) {
                this.notifyUpdate(x - 1, y, z, i - 1);
                this.notifyUpdate(x + 1, y, z, i - 1);
                this.notifyUpdate(x, y - 1, z, i - 1);
                this.notifyUpdate(x, y + 1, z, i - 1);
                this.notifyUpdate(x, y, z - 1, i - 1);
                this.notifyUpdate(x, y, z + 1, i - 1);
            }
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public TrackerType getType() {
        return this.type;
    }

    public void setType(TrackerType type) {
        this.type = type;
    }

    public void setCurrentQuest() {
        this.quest = Quest.getQuest(Quest.selectedQuestId);
    }

    public Quest getCurrentQuest() {
        return this.quest;
    }

    public void openInterface(EntityPlayer player) {
        DataWriter dw = PacketHandler.getWriter(PacketId.TRACKER_ACTIVATE);
        this.saveCoordinate(dw);
        this.save(dw, true);
        PacketHandler.sendToRawPlayer(player, dw);
    }

    private void saveCoordinate(DataWriter dw) {
        dw.writeData(this.field_145851_c, DataBitHelper.WORLD_COORDINATE);
        dw.writeData(this.field_145848_d, DataBitHelper.WORLD_COORDINATE);
        dw.writeData(this.field_145849_e, DataBitHelper.WORLD_COORDINATE);
    }

    private void save(DataWriter dw, boolean saveQuest) {
        if (saveQuest) {
            dw.writeBoolean(this.quest != null);
            if (this.quest != null) {
                dw.writeData((int)this.quest.getId(), DataBitHelper.QUESTS);
            }
        }
        dw.writeData(this.radius, DataBitHelper.WORLD_COORDINATE);
        dw.writeData(this.type.ordinal(), DataBitHelper.TRACKER_TYPE);
    }

    private void load(DataReader dr, boolean loadQuest) {
        if (loadQuest) {
            this.quest = dr.readBoolean() ? Quest.getQuest(dr.readData(DataBitHelper.QUESTS)) : null;
        }
        this.radius = dr.readData(DataBitHelper.WORLD_COORDINATE);
        this.type = TrackerType.values()[dr.readData(DataBitHelper.TRACKER_TYPE)];
    }

    private static TileEntityTracker getTracker(World world, DataReader dr) {
        int z;
        int y;
        int x = dr.readData(DataBitHelper.WORLD_COORDINATE);
        TileEntity te = world.func_147438_o(x, y = dr.readData(DataBitHelper.WORLD_COORDINATE), z = dr.readData(DataBitHelper.WORLD_COORDINATE));
        if (te instanceof TileEntityTracker) {
            return (TileEntityTracker)te;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void openInterface(EntityPlayer player, DataReader dr) {
        TileEntityTracker tracker = TileEntityTracker.getTracker(player.field_70170_p, dr);
        if (tracker != null) {
            tracker.load(dr, true);
            GuiWrapperEditMenu gui = new GuiWrapperEditMenu();
            ((GuiBase)gui).setEditMenu(new GuiEditMenuTracker((GuiBase)gui, player, tracker));
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
        }
    }

    public void sendToServer() {
        DataWriter dw = PacketHandler.getWriter(PacketId.TRACKER_RESPONSE);
        this.saveCoordinate(dw);
        this.save(dw, false);
        PacketHandler.sendToServer(dw);
    }

    public static void saveToServer(EntityPlayer player, DataReader dr) {
        TileEntityTracker tracker = TileEntityTracker.getTracker(player.field_70170_p, dr);
        if (Quest.isEditing && tracker != null) {
            tracker.load(dr, false);
        }
    }
}

