/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import java.util.List;

public abstract class IntegrationModule {
    public String getModID() {
        return null;
    }

    public boolean versionCheck() {
        String pattern = this.versionPattern();
        if (pattern == null) {
            return true;
        }
        List modList = Loader.instance().getModList();
        int n = modList.size();
        for (int i = 0; i < n; ++i) {
            ModContainer mod = (ModContainer)modList.get(i);
            if (!mod.getModId().equals(this.getModID())) continue;
            try {
                VersionRange validVersions = VersionRange.createFromVersionSpec((String)pattern);
                DefaultArtifactVersion version = new DefaultArtifactVersion(mod.getVersion());
                return validVersions.containsVersion((ArtifactVersion)version);
            }
            catch (InvalidVersionSpecificationException e) {
                return false;
            }
        }
        return false;
    }

    protected String versionPattern() {
        return null;
    }

    public abstract void init() throws Throwable;

    public abstract void postInit();
}

