/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.compat;

import com.cricketcraft.chisel.carving.Carving;
import com.cricketcraft.chisel.init.ChiselBlocks;
import com.cricketcraft.chisel.init.ChiselItems;
import com.google.common.collect.Maps;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public class Compatibility {
    public static String[] rockColorNames = new String[]{"gray", "lightgray", "brown", "tan", "reddish", "bluish", "greenish"};
    public static Map<Integer, String> tconMap = Maps.newHashMap();

    public static void init(FMLPostInitializationEvent event) {
        Compatibility.addSupport("ProjRed|Exploration", "projectred.exploration.stone", "marble", 0, 99);
        Compatibility.addSupport("ProjRed|Exploration", "projectred.exploration.stone", "marble", 1, 99);
        Compatibility.addSupport("bluepower", "marble", "marble", 0, 99);
        Compatibility.addSupport("Artifice", "artifice.marble", "marble", 0, 99);
        Compatibility.addSupport("Artifice", "artifice.marble.slab", "marble_slab", 0, 99);
        for (String s : rockColorNames) {
            Compatibility.addSupport("Artifice", "artifice.limestone." + s, "limestone", 0, 99);
        }
        Block block = GameRegistry.findBlock((String)"mariculture", (String)"limestone");
        if (block != null) {
            for (int i = 0; i < 16; ++i) {
                Compatibility.addSupport("limestone", block, i, 99);
            }
        }
        Compatibility.addSupport("PFAAGeologica", "strongStone", "marble", 5, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneSlab", "marbleSlab", 5, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneBrickStairs.marble", "marbleStairs", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStone", "limestone", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStoneSlab", "limestoneSlab", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStoneBrickStairs.limestone", "limestoneStairs", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneBrick", "stoneBrick", 3, 99);
        Compatibility.addSupport("PFAAGeologica", "strongCobble", "cobblestone", 3, 99);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            Compatibility.loadThaumcraftAspects();
        }
        for (Integer i : tconMap.keySet()) {
            Compatibility.addSupport("TConstruct", "decoration.multibrick", tconMap.get(i), i, 99);
            Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", tconMap.get(i), i, 99);
        }
        Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", "stonebricksmooth", 14, 99);
        Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", "stonebricksmooth", 15, 99);
        Compatibility.addSupport("Botania", "endStoneBrick", "end_stone", 12, 0);
        if (Loader.isModLoaded((String)"EE3")) {
            Compatibility.loadEE3Values();
        }
    }

    public static void addSupport(String modname, String blockname, String name, int metadata, int order) {
        if (Loader.isModLoaded((String)modname) && GameRegistry.findBlock((String)modname, (String)blockname) != null) {
            Compatibility.addSupport(name, GameRegistry.findBlock((String)modname, (String)blockname), metadata, order);
        }
    }

    public static void addSupport(String name, Block block, int metadata, int order) {
        Carving.chisel.addVariation(name, block, metadata, order);
    }

    private static void loadThaumcraftAspects() {
    }

    private static void loadEE3Values() {
        int x;
        FMLLog.log((String)"chisel", (Level)Level.INFO, (String)"[Chisel 2] Oooh is that Equivalent Exchange I see?", (Object[])new Object[0]);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Item)ChiselItems.ballomoss, 1), (float)16.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.sand_snakestone, 1, 1), (float)8.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.sand_snakestone, 1, 13), (float)8.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.cloud, 1, 0), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.cloud, 1, 1), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.cloud, 1, 2), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.cloud, 1, 3), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.cloud, 1, 4), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 1), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 2), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 3), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 4), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 12), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 13), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 14), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass_pane, 1, 15), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.present, 1, 4), (float)80.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.road_line, 1, 0), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.road_line, 1, 1), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.road_line, 1, 2), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.road_line, 1, 3), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.technical2, 1, 0), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.technical2, 1, 1), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.technical2, 1, 2), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.technical2, 1, 3), (float)24.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass2, 1), (float)1.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.technical2, 1, 0), (float)32.0f);
        for (x = 0; x < ChiselBlocks.pumpkin.length; ++x) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.pumpkin[x], 1), (float)144.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.jackolantern[x], 1), (float)153.0f);
        }
        for (x = 0; x < ChiselBlocks.torches.length; ++x) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack(ChiselBlocks.torches[x], 1), (float)9.0f);
        }
        for (x = 0; x < 10; ++x) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.valentines, 1, x), (float)3.0f);
        }
        for (x = 0; x < 16; ++x) {
            int c;
            if (x <= 10) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.concrete, 1, x), (float)8.0f);
            }
            if (x <= 14) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.grimstone, 1, x), (float)5.0f);
            }
            if (x < 14) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.grimstone, 1, x), (float)7.0f);
            }
            if (x < 12) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.dirt, 1, x), (float)1.0f);
            }
            if (x < 5) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.rebel, 1, x), (float)39.0f);
            }
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.fantasyblock, 1, x), (float)29444.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.fantasyblock, 1, x), (float)31444.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.limestone, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.marble, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.marble_pillar, 1, x), (float)8.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.marble_pillar_slab, 1, x), (float)4.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.sandstone_scribbles, 1, x), (float)4.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.stonebricksmooth, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.templeblock, 1, x), (float)108.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.mossy_templeblock, 1, x), (float)108.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glowstone, 1, x), (float)1536.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.ice, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.woolen_clay, 1, x), (float)153.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.factoryblock, 1, x), (float)32.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.hexPlating, 1, x), (float)37.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.gold_block, 1, x), (float)18432.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.iron_block, 1, x), (float)2304.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.laboratoryblock, 1, x), (float)33.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.technical, 1, x), (float)32.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.tyrian, 1, x), (float)33.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.hexLargePlating, 1, x), (float)37.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.circuits, 1, x), (float)37.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.factoryblock2, 1, x), (float)32.0f);
            if (x < 15) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.warningSign, 1, x), (float)6.0f);
            }
            if (x < 4) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.factoryblock2, 1, x), (float)32.0f);
            }
            for (c = 0; c < ChiselBlocks.stainedGlass.length; ++c) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.stainedGlass[c], 1, x), (float)1.0f);
            }
            for (c = 0; c < ChiselBlocks.stainedGlassPane.length; ++c) {
                if (x > 13) continue;
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.stainedGlassPane[c], 1, x), (float)1.0f);
            }
            if (x <= 0) continue;
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.cobblestone, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.mossy_cobblestone, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.netherrack, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.obsidian, 1, x), (float)64.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.sandstone, 1, x), (float)4.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.voidstonerunic, 1, x), (float)160.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.glass, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.redstone_block, 1, x), (float)288.0f);
            if (x <= 8) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.bookshelf, 1, x), (float)528.0f);
            }
            if (x <= 12) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.diamond_block, 1, x), (float)73728.0f);
                if (x != 12) {
                    EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.emerald_block, 1, x), (float)73728.0f);
                }
            }
            for (c = 0; c < ChiselBlocks.planks.length; ++c) {
                EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.planks[c], 1, x), (float)8.0f);
            }
        }
        for (x = 0; x <= 6; ++x) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.andesite, 1, x), (float)129.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.diorite, 1, x), (float)257.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.granite, 1, x), (float)513.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.lavastone, 1, x), (float)9.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.lavastone, 1, 7), (float)9.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.voidstone, 1, x), (float)160.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.voidstone, 1, 7), (float)160.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.voidstone2, 1, x), (float)256.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.voidstone2, 1, 7), (float)256.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.waterstone, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.ice_pillar, 1, x), (float)1.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.iron_bars, 1, x), (float)96.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.iron_bars, 1, 7), (float)96.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.iron_bars, 1, 8), (float)96.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.iron_bars, 1, 9), (float)96.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.paperwall, 1, x), (float)32.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.paperwall, 1, 7), (float)32.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.paperwall, 1, 8), (float)32.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.paperwall_block, 1, x), (float)32.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.paperwall_block, 1, 7), (float)32.0f);
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.paperwall_block, 1, 8), (float)32.0f);
            if (x <= 0) continue;
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack((Block)ChiselBlocks.brickCustom, 1, x), (float)256.0f);
        }
    }

    static {
        tconMap.put(0, "obsidian");
        tconMap.put(1, "sandstone");
        tconMap.put(2, "netherrack");
        tconMap.put(3, "stonebricksmooth");
        tconMap.put(12, "end_stone");
    }
}

