/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.network.message;

import com.cricketcraft.chisel.block.tileentity.TileEntityAutoChisel;
import com.cricketcraft.chisel.network.message.base.MessageCoords;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MessageAutoChisel
extends MessageCoords {
    ItemStack base;
    boolean playSound;
    boolean breakChisel;
    int chiseled;

    public MessageAutoChisel() {
    }

    public MessageAutoChisel(TileEntityAutoChisel tile, int chiseled, boolean playSound, boolean breakChisel) {
        super(tile);
        this.base = tile.func_70301_a(0);
        if (this.base != null) {
            this.base = this.base.func_77946_l();
        }
        this.playSound = playSound;
        this.breakChisel = breakChisel;
        this.chiseled = chiseled;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.playSound);
        buf.writeBoolean(this.breakChisel);
        buf.writeInt(this.chiseled);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.base);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.playSound = buf.readBoolean();
        this.breakChisel = buf.readBoolean();
        this.chiseled = buf.readInt();
        this.base = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<MessageAutoChisel, IMessage> {
        public IMessage onMessage(MessageAutoChisel message, MessageContext ctx) {
            TileEntity te = message.getTileEntity(ctx);
            if (te instanceof TileEntityAutoChisel) {
                ((TileEntityAutoChisel)te).doChiselAnim(message.base, message.chiseled, message.playSound, message.breakChisel);
            }
            return null;
        }
    }
}

