/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.render;

import cofh.lib.render.IFluidOverlayItem;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFluidOverlayItem
implements IItemRenderer {
    private final boolean canFlip;

    public RenderFluidOverlayItem() {
        this(true);
    }

    public RenderFluidOverlayItem(boolean canFlip) {
        this.canFlip = canFlip;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type.ordinal() < IItemRenderer.ItemRenderType.FIRST_PERSON_MAP.ordinal();
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return this.handleRenderType(item, type) & helper.ordinal() < IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK.ordinal();
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        Item item = stack.func_77973_b();
        FluidStack fluid = null;
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem fluidItem = (IFluidContainerItem)item;
            fluid = fluidItem.getFluid(stack);
        } else if (item instanceof IFluidOverlayItem && item.getRenderPasses(ItemHelper.getItemDamage(stack)) == 2) {
            fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        }
        this.doRenderItem(type, stack, item, fluid);
    }

    protected void doRenderItem(IItemRenderer.ItemRenderType type, ItemStack item, Item iconItem, FluidStack fluid) {
        boolean isFloaty;
        int colorMult;
        IIcon icon = iconItem.getIcon(item, 0);
        IIcon mask = iconItem.getIcon(item, 1);
        boolean hasFluid = fluid != null;
        IIcon fluidIcon = hasFluid ? fluid.getFluid().getIcon(fluid) : mask;
        int fluidSheet = hasFluid ? fluid.getFluid().getSpriteNumber() : 0;
        int n = colorMult = hasFluid ? fluid.getFluid().getColor(fluid) : 0xFFFFFF;
        boolean bl = hasFluid ? fluid.getFluid().getDensity(fluid) < 0 : (isFloaty = false);
        if (fluid == null) {
            fluidIcon = Blocks.field_150356_k.func_149691_a(2, 0);
            fluidSheet = 0;
            colorMult = 0x3F3F3F;
        }
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        float iconMinX = icon.func_94209_e();
        float iconMaxX = icon.func_94212_f();
        float iconMinY = icon.func_94206_g();
        float iconMaxY = icon.func_94210_h();
        float maskMinX = mask.func_94209_e();
        float maskMaxX = mask.func_94212_f();
        float maskMinY = mask.func_94206_g();
        float maskMaxY = mask.func_94210_h();
        float fluidMinX = fluidIcon.func_94209_e();
        float fluidMaxX = fluidIcon.func_94212_f();
        float fluidMinY = fluidIcon.func_94206_g();
        float fluidMaxY = fluidIcon.func_94210_h();
        if (isFloaty && this.canFlip) {
            iconMaxY = icon.func_94206_g();
            iconMinY = icon.func_94210_h();
            maskMaxY = mask.func_94206_g();
            maskMinY = mask.func_94210_h();
            fluidMaxY = fluidIcon.func_94206_g();
            fluidMinY = fluidIcon.func_94210_h();
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        int texture = GL11.glGetInteger((int)32873);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glDisable((int)2896);
            tessellator.func_78382_b();
            tessellator.func_78374_a(0.0, 16.0, 0.0, (double)iconMinX, (double)iconMaxY);
            tessellator.func_78374_a(16.0, 16.0, 0.0, (double)iconMaxX, (double)iconMaxY);
            tessellator.func_78374_a(16.0, 0.0, 0.0, (double)iconMaxX, (double)iconMinY);
            tessellator.func_78374_a(0.0, 0.0, 0.0, (double)iconMinX, (double)iconMinY);
            tessellator.func_78381_a();
            if (hasFluid) {
                tessellator.func_78382_b();
                tessellator.func_78374_a(0.0, 16.0, 0.001, (double)maskMinX, (double)maskMaxY);
                tessellator.func_78374_a(16.0, 16.0, 0.001, (double)maskMaxX, (double)maskMaxY);
                tessellator.func_78374_a(16.0, 0.0, 0.001, (double)maskMaxX, (double)maskMinY);
                tessellator.func_78374_a(0.0, 0.0, 0.001, (double)maskMinX, (double)maskMinY);
                tessellator.func_78381_a();
                GL11.glEnable((int)2884);
                GL11.glDepthFunc((int)514);
                GL11.glDepthMask((boolean)false);
                GL11.glMatrixMode((int)5890);
                this.bindTexture(RenderHelper.engine(), fluidSheet);
                OpenGlHelper.func_148821_a((int)1, (int)0, (int)1, (int)0);
                tessellator.func_78382_b();
                tessellator.func_78378_d(colorMult);
                tessellator.func_78374_a(0.0, 16.0, 0.001, (double)fluidMinX, (double)fluidMaxY);
                tessellator.func_78374_a(16.0, 16.0, 0.001, (double)fluidMaxX, (double)fluidMaxY);
                tessellator.func_78374_a(16.0, 0.0, 0.001, (double)fluidMaxX, (double)fluidMinY);
                tessellator.func_78374_a(0.0, 0.0, 0.001, (double)fluidMinX, (double)fluidMinY);
                tessellator.func_78381_a();
                GL11.glMatrixMode((int)5888);
                GL11.glDepthMask((boolean)true);
                GL11.glDepthFunc((int)515);
            }
            GL11.glEnable((int)2896);
        } else {
            GL11.glEnable((int)32826);
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslatef((float)0.5f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)iconMaxX, (float)iconMinY, (float)iconMinX, (float)iconMaxY, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            if (hasFluid) {
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                tessellator.func_78374_a(0.0, 0.0, 0.001, (double)maskMaxX, (double)maskMaxY);
                tessellator.func_78374_a(1.0, 0.0, 0.001, (double)maskMinX, (double)maskMaxY);
                tessellator.func_78374_a(1.0, 1.0, 0.001, (double)maskMinX, (double)maskMinY);
                tessellator.func_78374_a(0.0, 1.0, 0.001, (double)maskMaxX, (double)maskMinY);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                tessellator.func_78374_a(0.0, 1.0, -0.0635, (double)maskMinX, (double)maskMinY);
                tessellator.func_78374_a(1.0, 1.0, -0.0635, (double)maskMaxX, (double)maskMinY);
                tessellator.func_78374_a(1.0, 0.0, -0.0635, (double)maskMaxX, (double)maskMaxY);
                tessellator.func_78374_a(0.0, 0.0, -0.0635, (double)maskMinX, (double)maskMaxY);
                tessellator.func_78381_a();
                GL11.glEnable((int)2884);
                GL11.glDepthFunc((int)514);
                GL11.glDepthMask((boolean)false);
                this.bindTexture(RenderHelper.engine(), fluidSheet);
                OpenGlHelper.func_148821_a((int)1, (int)0, (int)1, (int)0);
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                tessellator.func_78378_d(colorMult);
                tessellator.func_78374_a(0.0, 0.0, 0.001, (double)fluidMaxX, (double)fluidMaxY);
                tessellator.func_78374_a(1.0, 0.0, 0.001, (double)fluidMinX, (double)fluidMaxY);
                tessellator.func_78374_a(1.0, 1.0, 0.001, (double)fluidMinX, (double)fluidMinY);
                tessellator.func_78374_a(0.0, 1.0, 0.001, (double)fluidMaxX, (double)fluidMinY);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                tessellator.func_78378_d(colorMult);
                tessellator.func_78374_a(0.0, 1.0, -0.0635, (double)fluidMinX, (double)fluidMinY);
                tessellator.func_78374_a(1.0, 1.0, -0.0635, (double)fluidMaxX, (double)fluidMinY);
                tessellator.func_78374_a(1.0, 0.0, -0.0635, (double)fluidMaxX, (double)fluidMaxY);
                tessellator.func_78374_a(0.0, 0.0, -0.0635, (double)fluidMinX, (double)fluidMaxY);
                tessellator.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glDepthFunc((int)515);
            }
            GL11.glDisable((int)32826);
        }
        GL11.glBindTexture((int)3553, (int)texture);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        GL11.glPopMatrix();
    }

    protected void bindTexture(TextureManager renderEngine, int spriteNumber) {
        if (spriteNumber == 0) {
            renderEngine.func_110577_a(RenderHelper.MC_BLOCK_SHEET);
        } else {
            GL11.glBindTexture((int)3553, (int)spriteNumber);
        }
    }
}

