/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAdvLakes
extends WorldGenerator {
    private static final List<WeightedRandomBlock> GAP_BLOCK = Arrays.asList(new WeightedRandomBlock(Blocks.field_150350_a, 0));
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    public List<WeightedRandomBlock> outlineBlock = null;
    public List<WeightedRandomBlock> gapBlock = GAP_BLOCK;
    public boolean solidOutline = false;
    public boolean totalOutline = false;
    public int width = 16;
    public int height = 8;

    public WorldGenAdvLakes(List<WeightedRandomBlock> resource, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genBlock = block == null ? null : block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int xStart, int yStart, int zStart) {
        int y;
        int x;
        int widthOff = this.width / 2;
        xStart -= widthOff;
        zStart -= widthOff;
        int heightOff = this.height / 2 + 1;
        while (yStart > heightOff && world.func_147437_c(xStart, yStart, zStart)) {
            --yStart;
        }
        if (yStart <= --heightOff) {
            return false;
        }
        yStart -= heightOff;
        boolean[] spawnBlock = new boolean[this.width * this.width * this.height];
        int W = this.width - 1;
        int H = this.height - 1;
        int e = rand.nextInt(4) + 4;
        for (int i = 0; i < e; ++i) {
            double xSize = rand.nextDouble() * 6.0 + 3.0;
            double ySize = rand.nextDouble() * 4.0 + 2.0;
            double zSize = rand.nextDouble() * 6.0 + 3.0;
            double xCenter = rand.nextDouble() * ((double)this.width - xSize - 2.0) + 1.0 + xSize / 2.0;
            double yCenter = rand.nextDouble() * ((double)this.height - ySize - 4.0) + 2.0 + ySize / 2.0;
            double zCenter = rand.nextDouble() * ((double)this.width - zSize - 2.0) + 1.0 + zSize / 2.0;
            for (int x2 = 1; x2 < W; ++x2) {
                for (int z = 1; z < W; ++z) {
                    for (int y2 = 1; y2 < H; ++y2) {
                        double xDist = ((double)x2 - xCenter) / (xSize / 2.0);
                        double yDist = ((double)y2 - yCenter) / (ySize / 2.0);
                        double zDist = ((double)z - zCenter) / (zSize / 2.0);
                        double dist = xDist * xDist + yDist * yDist + zDist * zDist;
                        if (!(dist < 1.0)) continue;
                        spawnBlock[(x2 * this.width + z) * this.height + y2] = true;
                    }
                }
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                for (y = 0; y < this.height; ++y) {
                    Material material;
                    boolean flag;
                    boolean bl = flag = spawnBlock[(x * this.width + z) * this.height + y] || x < W && spawnBlock[((x + 1) * this.width + z) * this.height + y] || x > 0 && spawnBlock[((x - 1) * this.width + z) * this.height + y] || z < W && spawnBlock[(x * this.width + (z + 1)) * this.height + y] || z > 0 && spawnBlock[(x * this.width + (z - 1)) * this.height + y] || y < H && spawnBlock[(x * this.width + z) * this.height + (y + 1)] || y > 0 && spawnBlock[(x * this.width + z) * this.height + (y - 1)];
                    if (!flag || !(y >= heightOff ? (material = world.func_147439_a(xStart + x, yStart + y, zStart + z).func_149688_o()).func_76224_d() : !WorldGenMinableCluster.canGenerateInBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock))) continue;
                    return false;
                }
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                for (y = 0; y < this.height; ++y) {
                    if (!spawnBlock[(x * this.width + z) * this.height + y]) continue;
                    if (y < heightOff) {
                        WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock, this.cluster);
                        continue;
                    }
                    if (!WorldGenMinableCluster.canGenerateInBlock(world, xStart + x, yStart + y, zStart + z, this.genBlock)) continue;
                    WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.gapBlock);
                }
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                for (y = 0; y < this.height; ++y) {
                    if (!spawnBlock[(x * this.width + z) * this.height + y] || !world.func_147439_a(xStart + x, yStart + y - 1, zStart + z).equals(Blocks.field_150346_d) || world.func_72972_b(EnumSkyBlock.Sky, xStart + x, yStart + y, zStart + z) <= 0) continue;
                    BiomeGenBase bgb = world.func_72807_a(xStart + x, zStart + z);
                    world.func_147465_d(xStart + x, yStart + y - 1, zStart + z, bgb.field_76752_A, bgb.field_150604_aj, 2);
                }
            }
        }
        if (this.outlineBlock != null) {
            for (x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.width; ++z) {
                    for (y = 0; y < this.height; ++y) {
                        boolean flag;
                        boolean bl = flag = !spawnBlock[(x * this.width + z) * this.height + y] && (x < W && spawnBlock[((x + 1) * this.width + z) * this.height + y] || x > 0 && spawnBlock[((x - 1) * this.width + z) * this.height + y] || z < W && spawnBlock[(x * this.width + (z + 1)) * this.height + y] || z > 0 && spawnBlock[(x * this.width + (z - 1)) * this.height + y] || y < H && spawnBlock[(x * this.width + z) * this.height + (y + 1)] || y > 0 && spawnBlock[(x * this.width + z) * this.height + (y - 1)]);
                        if (!flag || !(this.solidOutline | y < heightOff) && rand.nextInt(2) == 0 || !this.totalOutline && !world.func_147439_a(xStart + x, yStart + y, zStart + z).func_149688_o().func_76220_a()) continue;
                        WorldGenMinableCluster.generateBlock(world, xStart + x, yStart + y, zStart + z, this.outlineBlock);
                    }
                }
            }
        }
        return true;
    }
}

