/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common;

import com.stek101.projectzulu.common.CommonProxyProjectZulu;
import com.stek101.projectzulu.common.Module;
import com.stek101.projectzulu.common.Properties;
import com.stek101.projectzulu.common.core.CreativePZGeneralTab;
import com.stek101.projectzulu.common.core.CreativePZPotionTab;
import com.stek101.projectzulu.common.core.CustomEntityManager;
import com.stek101.projectzulu.common.core.ItemBlockManager;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.ZuluGuiHandler;
import com.stek101.projectzulu.common.core.network.PZPacketHandler;
import com.stek101.projectzulu.common.core.terrain.FeatureGenerator;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="ProjectZulu|Core", name="Project Zulu Core", dependencies="after:ExtrabiomesXL@", version="1.7.10-1.4c2", useMetadata=true)
public class ProjectZulu_Core {
    @Mod.Instance(value="ProjectZulu|Core")
    public static ProjectZulu_Core modInstance;
    private static int defaulteggID;
    public static final CreativeTabs projectZuluCreativeTab;
    public static final CreativeTabs projectZuluPotionTab;
    public static boolean enableTestBlock;
    public static boolean enableTemperature;
    public static int testBlockID;
    public static Block testBlock;
    public static final ItemArmor.ArmorMaterial desertClothMaterial;
    public static final ItemArmor.ArmorMaterial scaleMaterial;
    public static final ItemArmor.ArmorMaterial furMaterial;
    public static final ItemArmor.ArmorMaterial goldScaleMaterial;
    public static final ItemArmor.ArmorMaterial ironScaleMaterial;
    public static final ItemArmor.ArmorMaterial diamondScaleMaterial;
    public static final ItemArmor.ArmorMaterial steelMaterial;
    public static File modConfigDirectoryFile;
    public static final FeatureGenerator featureGenerator;
    public static final PZPacketHandler packetHandler;
    @SidedProxy(clientSide="com.stek101.projectzulu.common.ClientProxyProjectZulu", serverSide="com.stek101.projectzulu.common.CommonProxyProjectZulu")
    public static CommonProxyProjectZulu proxy;
    private List<ModuleInfo> modules = new ArrayList<ModuleInfo>();

    public static int getNextDefaultEggID() {
        return defaulteggID++;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        modConfigDirectoryFile = event.getModConfigurationDirectory();
        ProjectZuluLog.configureLogging(modConfigDirectoryFile);
        this.attemptLoadModule("com.stek101.projectzulu.common.ProjectZulu_Blocks");
        this.attemptLoadModule("com.stek101.projectzulu.common.ProjectZulu_Mobs");
        this.attemptLoadModule("com.stek101.projectzulu.common.ProjectZulu_Dungeon");
        this.attemptLoadModule("com.stek101.projectzulu.common.ProjectZulu_World");
        Configuration moduleConfig = new Configuration(new File(event.getModConfigurationDirectory(), "/Project Zulu/ProjectZuluModules.cfg"));
        moduleConfig.load();
        for (ModuleInfo moduleInfo : this.modules) {
            moduleInfo.isEnabled = moduleConfig.get("isEnabled", moduleInfo.getIdentifier(), true, "Set to false to disable module.").getBoolean(true);
            if (moduleInfo.isEnabled) {
                ProjectZuluLog.info("Module [%s] settings read and will be loaded.", moduleInfo.getIdentifier());
                continue;
            }
            ProjectZuluLog.info("Module [%s] settings read and will be disabled.", moduleInfo.getIdentifier());
        }
        moduleConfig.save();
        Configuration zuluConfig = new Configuration(new File(event.getModConfigurationDirectory(), "/Project Zulu/ProjectZuluConfig.cfg"));
        Properties.loadFromConfig(modConfigDirectoryFile);
        zuluConfig.load();
        enableTemperature = zuluConfig.get("General Controls", "enableTemperature", enableTemperature).getBoolean(enableTemperature);
        zuluConfig.save();
        ProjectZuluLog.info("Registering Events", new Object[0]);
        proxy.bossHealthTicker();
        proxy.keyBindinit();
        proxy.eventHooks(modConfigDirectoryFile);
        for (ModuleInfo moduleInfo : this.modules) {
            if (!moduleInfo.isEnabled) continue;
            moduleInfo.module.registration(CustomEntityManager.INSTANCE);
            moduleInfo.module.registration(ItemBlockManager.INSTANCE);
            moduleInfo.module.registration(featureGenerator);
            moduleInfo.module.preInit(event, modConfigDirectoryFile);
        }
        ProjectZuluLog.info("Load Entity Moxdels and Render", new Object[0]);
        proxy.registerModelsAndRender();
        ProjectZuluLog.info("Load Entity Properties", new Object[0]);
        CustomEntityManager.INSTANCE.loadCreaturesFromConfig(modConfigDirectoryFile);
        ProjectZuluLog.info("Starting ItemBlock Setup", new Object[0]);
        ItemBlockManager.INSTANCE.createBlocks(modConfigDirectoryFile);
        ProjectZuluLog.info("Starting ItemBlock Registration", new Object[0]);
        ItemBlockManager.INSTANCE.registerBlocks();
        ProjectZuluLog.info("Completed ItemBlock Registration", new Object[0]);
        ProjectZuluLog.info("Registering Entites", new Object[0]);
        CustomEntityManager.INSTANCE.registerEntities(modConfigDirectoryFile);
    }

    private void attemptLoadModule(String classResourceName) {
        try {
            Class<?> moduleClass = Class.forName(classResourceName);
            if (Module.class.isAssignableFrom(moduleClass)) {
                Module module = (Module)moduleClass.newInstance();
                ProjectZuluLog.info("Detected %s module.", module.getIdentifier());
                this.modules.add(new ModuleInfo(module));
            }
        }
        catch (ClassNotFoundException e) {
            ProjectZuluLog.info("Module [%s] missing; will be disabled.", classResourceName);
        }
        catch (InstantiationException e) {
            ProjectZuluLog.severe("Failed to instantiate %s, report to modder.", classResourceName);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            ProjectZuluLog.severe("Failed to instantiate %s, report to modder.", classResourceName);
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)modInstance, (IGuiHandler)new ZuluGuiHandler());
        packetHandler.init();
        for (ModuleInfo moduleInfo : this.modules) {
            if (!moduleInfo.isEnabled) continue;
            moduleInfo.module.init(event, modConfigDirectoryFile);
        }
        ProjectZuluLog.info("Load Entity Biomes", new Object[0]);
        CustomEntityManager.INSTANCE.loadBiomesFromConfig(modConfigDirectoryFile);
        ProjectZuluLog.info("Register Entity Spawns", new Object[0]);
        CustomEntityManager.INSTANCE.addSpawns();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ProjectZuluLog.info("Initializing TerrainFeatures", new Object[0]);
        featureGenerator.initialize(modConfigDirectoryFile);
        GameRegistry.registerWorldGenerator((IWorldGenerator)featureGenerator, (int)1);
        for (ModuleInfo moduleInfo : this.modules) {
            if (!moduleInfo.isEnabled) continue;
            moduleInfo.module.postInit(event, modConfigDirectoryFile);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        for (ModuleInfo moduleInfo : this.modules) {
            if (!moduleInfo.isEnabled) continue;
            moduleInfo.module.serverStarting(event, modConfigDirectoryFile);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        for (ModuleInfo moduleInfo : this.modules) {
            if (!moduleInfo.isEnabled) continue;
            moduleInfo.module.serverStart(event, modConfigDirectoryFile);
        }
    }

    static {
        defaulteggID = 300;
        projectZuluCreativeTab = new CreativePZGeneralTab(CreativeTabs.field_78032_a.length, "projectZuluTab");
        projectZuluPotionTab = new CreativePZPotionTab(CreativeTabs.field_78032_a.length, "projectZuluPotionTab");
        enableTestBlock = false;
        enableTemperature = false;
        testBlockID = 2540;
        desertClothMaterial = EnumHelper.addArmorMaterial((String)"Desert Cloth Material", (int)2, (int[])new int[]{1, 2, 1, 1}, (int)15);
        scaleMaterial = EnumHelper.addArmorMaterial((String)"Scale Material", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)15);
        furMaterial = EnumHelper.addArmorMaterial((String)"Fur Material", (int)3, (int[])new int[]{1, 3, 2, 1}, (int)13);
        goldScaleMaterial = EnumHelper.addArmorMaterial((String)"Gold Scale Material", (int)7, (int[])new int[]{2, 5, 3, 1}, (int)25);
        ironScaleMaterial = EnumHelper.addArmorMaterial((String)"Iron Scale Material", (int)15, (int[])new int[]{2, 6, 5, 2}, (int)9);
        diamondScaleMaterial = EnumHelper.addArmorMaterial((String)"Diamond Scale Material", (int)33, (int[])new int[]{3, 8, 6, 3}, (int)10);
        steelMaterial = EnumHelper.addArmorMaterial((String)"Steel Material", (int)20, (int[])new int[]{3, 8, 6, 3}, (int)10);
        featureGenerator = new FeatureGenerator();
        packetHandler = new PZPacketHandler();
    }

    private class ModuleInfo {
        public Module module;
        public boolean isEnabled;

        public ModuleInfo(Module module) {
            this.module = module;
            this.isEnabled = true;
        }

        public String getIdentifier() {
            return this.module.getIdentifier();
        }
    }
}

