/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.itemblockdeclaration;

import com.stek101.projectzulu.common.core.itemblockdeclaration.ItemBlockDeclaration;
import cpw.mods.fml.relauncher.Side;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class ItemDeclaration
implements ItemBlockDeclaration {
    private int registerPass;
    public final String name;
    private boolean isEnabled = true;
    private boolean isCreated = false;

    public ItemDeclaration(String name) {
        this(name, 0);
    }

    public ItemDeclaration(String name, int registerPass) {
        this.name = name;
        this.registerPass = registerPass;
    }

    @Override
    public ItemBlockDeclaration.Type getType() {
        return ItemBlockDeclaration.Type.Item;
    }

    @Override
    public int getRegisterPass() {
        return this.registerPass;
    }

    @Override
    public void createWithConfig(Configuration config, boolean readOnly) {
        if (!readOnly) {
            Property property = config.get("item", this.name + " isEnabled", this.isEnabled);
            this.isEnabled = property.getBoolean(this.isEnabled);
            if (this.isEnabled) {
                this.preCreateLoadConfig(config);
                this.isCreated = this.createItem();
                this.postCreateLoadConfig(config);
            }
        }
    }

    protected void preCreateLoadConfig(Configuration config) {
    }

    protected void postCreateLoadConfig(Configuration config) {
    }

    protected abstract boolean createItem();

    @Override
    public final void register(Side side) {
        if (this.isCreated) {
            this.registerItem();
            if (!side.isServer()) {
                this.clientRegisterItem();
            }
        }
    }

    protected abstract void registerItem();

    protected void clientRegisterItem() {
    }
}

