/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.google.common.base.CharMatcher;
import com.stek101.projectzulu.common.core.ObfuscationHelper;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.DataFields;
import com.stek101.projectzulu.common.dungeon.GUIEditNodeTextField;
import com.stek101.projectzulu.common.dungeon.GUINBTList;
import com.stek101.projectzulu.common.dungeon.GuiLimitedMobSpawner;
import com.stek101.projectzulu.common.dungeon.GuiSaveableTextField;
import com.stek101.projectzulu.common.dungeon.ListType;
import com.stek101.projectzulu.common.dungeon.NBTNode;
import com.stek101.projectzulu.common.dungeon.NBTTree;
import com.stek101.projectzulu.common.dungeon.TileEntityLimitedMobSpawnData;
import com.stek101.projectzulu.common.dungeon.TileEntityLimitedMobSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public class CreatureFields
implements DataFields {
    private boolean isEnabled = true;
    private GuiSaveableTextField creatureNameField;
    private GuiSaveableTextField soundNameField;
    private GuiSaveableTextField weightedChanceField;
    private GuiSaveableTextField optionalParameter;
    private GUIEditNodeTextField selectedTagField;
    private NBTTagCompound loadedNBT = null;
    private GuiButton searchForEntity;
    private GuiButton searchForSound;
    private GuiButton resetNBTList;
    private GuiButton saveCurNBT;
    private GuiButton discardCurNBT;
    private GUINBTList nbtList;
    private NBTTree nbtTree;
    public Minecraft mc;
    Point screenSize;
    Point backgroundSize;
    public static final ResourceLocation CREATURE_LIST = new ResourceLocation("projectzuludungeon", "textures/creaturelistgui.png");

    CreatureFields(Minecraft mc) {
        this.mc = mc;
    }

    @Override
    public DataFields createFields(Minecraft mc, int screenWidth, int screenHeight, Point backgroundSize) {
        if (this.creatureNameField == null) {
            this.creatureNameField = new GuiSaveableTextField(mc.field_71466_p, 60, new Point(screenWidth, screenHeight), backgroundSize, new Point(82, 27), new Point(116, 18));
            this.soundNameField = new GuiSaveableTextField(mc.field_71466_p, 60, new Point(screenWidth, screenHeight), backgroundSize, new Point(82, 49), new Point(116, 18));
            this.weightedChanceField = new GuiSaveableTextField(mc.field_71466_p, 2, new Point(screenWidth, screenHeight), backgroundSize, new Point(206, 72), new Point(20, 18));
            this.selectedTagField = new GUIEditNodeTextField(mc.field_71466_p, 60, new Point(screenWidth, screenHeight), backgroundSize, new Point(8, 181), new Point(116, 18));
            this.optionalParameter = new GuiSaveableTextField(mc.field_71466_p, 2400, new Point(screenWidth, screenHeight), backgroundSize, new Point(34, 72), new Point(116, 18));
        } else {
            this.creatureNameField = new GuiSaveableTextField(this.creatureNameField, mc.field_71466_p, 60, new Point(screenWidth, screenHeight), backgroundSize, new Point(82, 27), new Point(116, 18));
            this.soundNameField = new GuiSaveableTextField(this.soundNameField, mc.field_71466_p, 60, new Point(screenWidth, screenHeight), backgroundSize, new Point(82, 49), new Point(116, 18));
            this.weightedChanceField = new GuiSaveableTextField(this.weightedChanceField, mc.field_71466_p, 2, new Point(screenWidth, screenHeight), backgroundSize, new Point(205, 72), new Point(20, 18));
            this.selectedTagField = new GUIEditNodeTextField(this.selectedTagField, mc.field_71466_p, 60, new Point(screenWidth, screenHeight), backgroundSize, new Point(8, 181), new Point(116, 18));
            this.optionalParameter = new GuiSaveableTextField(this.optionalParameter, mc.field_71466_p, 2400, new Point(screenWidth, screenHeight), backgroundSize, new Point(34, 72), new Point(116, 18));
        }
        this.searchForEntity = new GuiButton(1, (screenWidth - backgroundSize.getX()) / 2 + 201, (screenHeight - backgroundSize.getY()) / 2 + 38 - 15 - 3, 20, 20, "...");
        this.searchForSound = new GuiButton(2, (screenWidth - backgroundSize.getX()) / 2 + 201, (screenHeight - backgroundSize.getY()) / 2 + 38 + 10 - 6, 20, 20, "...");
        this.resetNBTList = new GuiButton(3, (screenWidth - backgroundSize.getX()) / 2 + 78, (screenHeight - backgroundSize.getY()) / 2 + 219, 70, 20, "Recreate NBT");
        this.saveCurNBT = new GuiButton(4, (screenWidth - backgroundSize.getX()) / 2 + 151, (screenHeight - backgroundSize.getY()) / 2 + 175, 34, 20, "Save");
        this.discardCurNBT = new GuiButton(5, (screenWidth - backgroundSize.getX()) / 2 + 187, (screenHeight - backgroundSize.getY()) / 2 + 175, 34, 20, "Abort");
        if (this.nbtList != null) {
            this.nbtList = new GUINBTList(this, mc, this.nbtTree, 214, new Point(screenWidth, screenHeight), backgroundSize);
        }
        this.screenSize = new Point(screenWidth, screenHeight);
        this.backgroundSize = backgroundSize;
        return this;
    }

    @Override
    public void loadFromTileEntity(TileEntityLimitedMobSpawner limitedMobSpawner, int elementID) {
        if (limitedMobSpawner.getSpawnList() != null && limitedMobSpawner.getSpawnList().size() > elementID - 1) {
            TileEntityLimitedMobSpawnData spawnEntryData = limitedMobSpawner.getSpawnList().get(elementID - 1);
            if (spawnEntryData.type.length() > 0) {
                this.creatureNameField.func_146180_a(spawnEntryData.type);
                this.weightedChanceField.func_146180_a(Integer.toString(spawnEntryData.field_76292_a));
                this.optionalParameter.func_146180_a(spawnEntryData.optionalParameters);
                this.loadedNBT = (NBTTagCompound)spawnEntryData.properties.func_74737_b();
                if (this.loadedNBT != null) {
                    this.nbtTree = new NBTTree((NBTBase)this.loadedNBT, "Properties");
                    this.nbtList = new GUINBTList(this, this.mc, this.nbtTree, 214, this.screenSize, this.backgroundSize);
                }
                this.soundNameField.func_146180_a(spawnEntryData.spawnSound);
                this.setIsEnabled(true);
            }
        }
    }

    @Override
    public void saveToTileEntity(TileEntityLimitedMobSpawner limitedMobSpawner) {
        if (this.isEnabled() && this.isEntryValid()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Type", this.creatureNameField.func_146179_b());
            nbt.func_74768_a("Weight", Integer.parseInt(this.weightedChanceField.func_146179_b()));
            nbt.func_74782_a("Properties", (NBTBase)this.nbtTree.toNBTTagCompound());
            nbt.func_74778_a("SpawnSound", this.soundNameField.func_146179_b());
            nbt.func_74778_a("OptionalParameter", this.optionalParameter.func_146179_b());
            limitedMobSpawner.getSpawnList().add(new TileEntityLimitedMobSpawnData(limitedMobSpawner, nbt));
        }
    }

    private boolean isEntryValid() {
        if (this.nbtTree == null) {
            ProjectZuluLog.info("Rejecting Mob Spawner Entry due to Invalid NBT data", new Object[0]);
            return false;
        }
        if (this.creatureNameField.func_146179_b().length() > 0 && EntityList.field_75625_b.containsKey(this.creatureNameField.func_146179_b()) && this.weightedChanceField.func_146179_b().length() > 0) {
            return true;
        }
        ProjectZuluLog.info("Rejecting Mob Spawner Entry due to Invalid data", new Object[0]);
        return false;
    }

    public void setDataFromList(String data, ListType listType) {
        switch (listType) {
            case Creature: {
                this.creatureNameField.func_146180_a(data);
                this.resetNBTList();
                break;
            }
            case Sound: {
                this.soundNameField.func_146180_a(data);
                break;
            }
        }
    }

    private void resetNBTList() {
        EntityLivingBase desiredEntity = (EntityLivingBase)EntityList.func_75620_a((String)this.creatureNameField.func_146179_b(), (World)Minecraft.func_71410_x().field_71441_e);
        if (desiredEntity != null) {
            try {
                ObfuscationHelper.setCatchableFieldUsingReflection("field_110155_d", EntityLivingBase.class, desiredEntity, true, new ServersideAttributeMap());
            }
            catch (Exception e) {
                ObfuscationHelper.setFieldUsingReflection("attributeMap", EntityLivingBase.class, desiredEntity, true, new ServersideAttributeMap());
            }
            ObfuscationHelper.invokeMethod("applyEntityAttributes", "func_110147_ax", EntityLivingBase.class, desiredEntity, new Object[0]);
            this.loadedNBT = new NBTTagCompound();
            desiredEntity.func_70109_d(this.loadedNBT);
            this.nbtTree = new NBTTree((NBTBase)this.loadedNBT, "Properties");
            this.nbtList = new GUINBTList(this, this.mc, this.nbtTree, 214, this.screenSize, this.backgroundSize);
        }
    }

    public void setSelectedCurentNode(NBTNode tag) {
        this.selectedTagField.setSelectedNode(tag);
    }

    @Override
    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean keyboardInput(char keyChar, int keyID) {
        if (this.isEnabled) {
            if (this.creatureNameField.func_146201_a(keyChar, keyID)) {
                return true;
            }
            if (this.weightedChanceField.func_146201_a(keyChar, keyID)) {
                String newString;
                String originalString = this.weightedChanceField.func_146179_b();
                if (!originalString.equals(newString = CharMatcher.anyOf((CharSequence)"0123456789").retainFrom((CharSequence)this.weightedChanceField.func_146179_b()))) {
                    this.weightedChanceField.func_146180_a(newString);
                }
                return true;
            }
            if (this.soundNameField.func_146201_a(keyChar, keyID)) {
                return true;
            }
            if (this.selectedTagField.func_146201_a(keyChar, keyID)) {
                return true;
            }
            if (this.optionalParameter.func_146201_a(keyChar, keyID)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(GuiLimitedMobSpawner spawnerGUI, Minecraft mc, int par1, int par2, int par3) {
        if (this.isEnabled) {
            this.creatureNameField.func_146192_a(par1, par2, par3);
            this.weightedChanceField.func_146192_a(par1, par2, par3);
            this.soundNameField.func_146192_a(par1, par2, par3);
            this.selectedTagField.func_146192_a(par1, par2, par3);
            this.optionalParameter.func_146192_a(par1, par2, par3);
            if (par3 == 0 && this.searchForEntity.func_146116_c(mc, par1, par2)) {
                if (spawnerGUI.currentListType == ListType.Creature) {
                    spawnerGUI.closeList();
                } else {
                    spawnerGUI.openList(ListType.Creature);
                }
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)0.8f));
            }
            if (par3 == 0 && this.searchForSound.func_146116_c(mc, par1, par2)) {
                if (spawnerGUI.currentListType == ListType.Sound) {
                    spawnerGUI.closeList();
                } else {
                    spawnerGUI.openList(ListType.Sound);
                }
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            if (par3 == 0 && this.resetNBTList.func_146116_c(mc, par1, par2)) {
                this.resetNBTList();
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            if (par3 == 0 && this.saveCurNBT.func_146116_c(mc, par1, par2) && this.selectedTagField.isEnabled() && this.nbtTree != null) {
                this.selectedTagField.saveAndClear(this.nbtTree);
                this.nbtList.recreateNodeList();
                this.loadedNBT = this.nbtTree.toNBTTagCompound();
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            if (par3 == 0 && this.discardCurNBT.func_146116_c(mc, par1, par2) && this.selectedTagField.isEnabled()) {
                this.selectedTagField.clear();
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
        }
    }

    @Override
    public void mouseHover(int par1, int par2, int par3) {
        if (this.isEnabled) {
            // empty if block
        }
    }

    @Override
    public void render(Minecraft mc, int par1, int par2, float par3, Point screenSize, Point backgroundSize) {
        if (this.nbtList != null) {
            this.nbtList.drawScreen(screenSize, backgroundSize, par1, par2, par3);
        }
        this.resetNBTList.func_146112_a(mc, par1, par2);
        this.saveCurNBT.func_146112_a(mc, par1, par2);
        this.discardCurNBT.func_146112_a(mc, par1, par2);
        this.searchForEntity.func_146112_a(mc, par1, par2);
        this.searchForSound.func_146112_a(mc, par1, par2);
        mc.field_71466_p.func_78276_b("Name", (screenSize.getX() - backgroundSize.getX()) / 2 + 48, (screenSize.getY() - backgroundSize.getY()) / 2 + 48 - 15 - 3, 0x404040);
        mc.field_71466_p.func_78276_b("Sound", (screenSize.getX() - backgroundSize.getX()) / 2 + 48, (screenSize.getY() - backgroundSize.getY()) / 2 + 48 + 10 - 6, 0x404040);
        mc.field_71466_p.func_78276_b("Weight", (screenSize.getX() - backgroundSize.getX()) / 2 + 168, (screenSize.getY() - backgroundSize.getY()) / 2 + 74, 0x404040);
        mc.field_71466_p.func_78276_b("Tags", (screenSize.getX() - backgroundSize.getX()) / 2 + 6, (screenSize.getY() - backgroundSize.getY()) / 2 + 74, 0x404040);
        this.bindTexture(mc);
        this.drawBackgroundBox(new Point(80, 20), screenSize, backgroundSize, new Point(136, 66), new Point(120, 20));
        this.drawBackgroundBox(new Point(80, 42), screenSize, backgroundSize, new Point(136, 66), new Point(120, 20));
        this.drawBackgroundBox(new Point(201, 64), screenSize, backgroundSize, new Point(236, 0), new Point(20, 20));
        this.drawBackgroundBox(new Point(32, 64), screenSize, backgroundSize, new Point(136, 66), new Point(120, 20));
        if (this.selectedTagField.isEnabled()) {
            this.drawBackgroundBox(new Point(6, 175), screenSize, backgroundSize, new Point(136, 66), new Point(120, 20));
        } else {
            this.drawBackgroundBox(new Point(6, 175), screenSize, backgroundSize, new Point(136, 89), new Point(120, 20));
        }
        this.creatureNameField.func_146194_f();
        this.soundNameField.func_146194_f();
        this.weightedChanceField.func_146194_f();
        this.selectedTagField.func_146194_f();
        this.optionalParameter.func_146194_f();
    }

    private void bindTexture(Minecraft mc) {
        mc.field_71446_o.func_110577_a(CREATURE_LIST);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawBackgroundBox(Point position, Point screenSize, Point backgroundSize, Point imageLocation, Point imageSize) {
        int xCoord = (screenSize.getX() - backgroundSize.getX()) / 2 + position.getX();
        int yCoord = (screenSize.getY() - backgroundSize.getY()) / 2 + position.getY();
        this.drawTexturedModalRect(xCoord, yCoord, imageLocation.getX(), imageLocation.getY(), imageSize.getX(), imageSize.getY());
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a((double)(par1 + par5), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78381_a();
    }
}

