/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.stek101.projectzulu.common.dungeon.ButtonIDs;
import com.stek101.projectzulu.common.dungeon.CreatureFields;
import com.stek101.projectzulu.common.dungeon.GuiLimitedMobSpawner;
import com.stek101.projectzulu.common.dungeon.GuiScrollingList;
import com.stek101.projectzulu.common.dungeon.ListType;
import com.stek101.projectzulu.common.dungeon.Node;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public class GUISelectionList
extends GuiScrollingList {
    private GuiLimitedMobSpawner parent;
    ListType listType;
    int selectedElement = -1;
    Node currentNode;
    GuiButton previous;
    public static final ResourceLocation CREATURE_GUI = new ResourceLocation("projectzuludungeon", "textures/creaturelistgui.png");

    public GUISelectionList(GuiLimitedMobSpawner parent, Node rootSoundNode, ListType listType, int listWidth, Point screenSize, Point backgroundSize) {
        super(parent.getMinecraft(), listWidth, backgroundSize.getY() + 50, (screenSize.getY() - backgroundSize.getY()) / 2 + 25, (screenSize.getY() - backgroundSize.getY()) / 2 + backgroundSize.getY() - 20, (screenSize.getX() - backgroundSize.getX()) / 2 + 234, parent.getMinecraft().field_71466_p.field_78288_b + 8);
        this.parent = parent;
        this.currentNode = rootSoundNode;
        this.listType = listType;
        this.previous = new GuiButton(ButtonIDs.BACKWARDS.index, screenSize.getX() / 2 + 106, (screenSize.getY() + backgroundSize.getY()) / 2 - 240, 85, 20, "Parent Dir.");
    }

    @Override
    protected int getSize() {
        return this.currentNode.numberOfChildren();
    }

    @Override
    protected void elementClicked(int clickedIndex, boolean var2) {
        Node childNode = this.currentNode.getChild(clickedIndex);
        if (childNode.numberOfChildren() > 0) {
            this.currentNode = childNode;
        } else if (this.parent.getDataField(this.parent.currentDataField) instanceof CreatureFields) {
            ((CreatureFields)this.parent.getDataField(this.parent.currentDataField)).setDataFromList(this.currentNode.getChild(clickedIndex).getFullName(), this.listType);
            this.parent.closeList();
        }
    }

    @Override
    protected boolean isSelected(int selectedIndex) {
        return selectedIndex == this.selectedElement;
    }

    @Override
    protected void drawBackground() {
        this.parent.getMinecraft().field_71446_o.func_110577_a(CREATURE_GUI);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xCoord = (this.parent.field_146294_l - this.parent.backgroundSize.getX()) / 2 + 230;
        int yCoord = (this.parent.field_146295_m - this.parent.backgroundSize.getY()) / 2;
        this.parent.func_73729_b(xCoord, yCoord, 0, 0, 91, 244);
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    @Override
    protected void drawSlot(int listIndex, int var2, int var3, int var4, Tessellator tessellator) {
        if (this.currentNode.numberOfChildren() <= listIndex) {
            return;
        }
        String renderString = this.currentNode.getChild(listIndex).getName();
        boolean addDirTag = this.currentNode.getChild(listIndex).numberOfChildren() != 0;
        renderString = addDirTag ? "D:" + renderString : renderString;
        renderString = renderString.length() > 13 ? renderString.substring(0, 13) : renderString;
        this.parent.func_73731_b(this.parent.getMinecraft().field_71466_p, renderString, this.left + 3, var3 + 2, 0xFFFFFF);
    }

    public void drawScreen(Point screenSize, Point backgroundSize, int mouseX, int mouseY, float p_22243_3_) {
        super.drawScreen(mouseX, mouseY, p_22243_3_);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2929);
        this.drawScrollOverlay(this.left, (screenSize.getY() - backgroundSize.getY()) / 2 + 4, this.top, 255, 255);
        this.drawScrollOverlay(this.left, this.bottom, (screenSize.getY() - backgroundSize.getY()) / 2 + backgroundSize.getY() - 4, 255, 255);
        this.previous.func_146112_a(this.parent.getMinecraft(), mouseX, mouseY);
    }

    private void drawScrollOverlay(int leftOffset, int topHeight, int botHeight, int alphaBottom, int alphaTop) {
        Tessellator var5 = Tessellator.field_78398_a;
        GL11.glBindTexture((int)3553, (int)this.parent.getMinecraft().field_71446_o.func_110581_b(this.getBackgroundTexture()).func_110552_b());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float imageSize = 32.0f;
        var5.func_78382_b();
        var5.func_78374_a((double)leftOffset, (double)botHeight, 0.0, 0.0, (double)((float)botHeight / imageSize));
        var5.func_78374_a((double)leftOffset + (double)this.listWidth, (double)botHeight, 0.0, (double)((float)this.listWidth / imageSize), (double)((float)botHeight / imageSize));
        var5.func_78374_a((double)leftOffset + (double)this.listWidth, (double)topHeight, 0.0, (double)((float)this.listWidth / imageSize), (double)((float)topHeight / imageSize));
        var5.func_78374_a((double)leftOffset, (double)topHeight, 0.0, 0.0, (double)((float)topHeight / imageSize));
        var5.func_78381_a();
    }

    public void mouseClicked(int par1, int par2, int par3) {
        if (par3 == 0 && this.previous.func_146116_c(this.parent.getMinecraft(), par1, par2) && this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
            this.parent.getMinecraft().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }
}

