/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.stek101.projectzulu.common.core.ObfuscationHelper;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.NBTNode;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public enum NBTHelper {
    TAG_END(0){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
        }

        @Override
        String getValue(NBTBase currentTag) {
            return "";
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            return null;
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
        }
    }
    ,
    TAG_BYTE(1){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagByte nbtTag = (NBTTagByte)currentNode.getData();
            nbtTagCompound.func_74774_a(currentNode.getTagName(), nbtTag.func_150290_f());
        }

        @Override
        String getValue(NBTBase currentTag) {
            return Byte.toString(((NBTTagByte)currentTag).func_150290_f());
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagByte nbtTag = (NBTTagByte)currentNBT;
            return new NBTTagByte(Byte.parseByte(newValue));
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_SHORT(2){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagShort nbtTag = (NBTTagShort)currentNode.getData();
            nbtTagCompound.func_74777_a(currentNode.getTagName(), nbtTag.func_150289_e());
        }

        @Override
        String getValue(NBTBase currentTag) {
            return Short.toString(((NBTTagShort)currentTag).func_150289_e());
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagShort nbtTag = (NBTTagShort)currentNBT;
            return new NBTTagShort(Short.parseShort(newValue));
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_INT(3){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagInt nbtTag = (NBTTagInt)currentNode.getData();
            nbtTagCompound.func_74768_a(currentNode.getTagName(), nbtTag.func_150287_d());
        }

        @Override
        String getValue(NBTBase currentTag) {
            return Integer.toString(((NBTTagInt)currentTag).func_150287_d());
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagInt nbtTag = (NBTTagInt)currentNBT;
            return new NBTTagInt(Integer.parseInt(newValue));
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_LONG(4){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagLong nbtTag = (NBTTagLong)currentNode.getData();
            nbtTagCompound.func_74772_a(currentNode.getTagName(), nbtTag.func_150291_c());
        }

        @Override
        String getValue(NBTBase currentTag) {
            return Long.toString(((NBTTagLong)currentTag).func_150291_c());
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagLong nbtTag = (NBTTagLong)currentNBT;
            return new NBTTagLong(Long.parseLong(newValue));
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_FLOAT(5){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagFloat nbtTag = (NBTTagFloat)currentNode.getData();
            nbtTagCompound.func_74776_a(currentNode.getTagName(), nbtTag.func_150288_h());
        }

        @Override
        String getValue(NBTBase currentTag) {
            return Float.toString(((NBTTagFloat)currentTag).func_150288_h());
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagFloat nbtTag = (NBTTagFloat)currentNBT;
            return new NBTTagFloat(Float.parseFloat(newValue));
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_DOUBLE(6){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagDouble nbtTag = (NBTTagDouble)currentNode.getData();
            nbtTagCompound.func_74780_a(currentNode.getTagName(), nbtTag.func_150286_g());
        }

        @Override
        String getValue(NBTBase currentTag) {
            return Double.toString(((NBTTagDouble)currentTag).func_150286_g());
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagDouble nbtTag = (NBTTagDouble)currentNBT;
            return new NBTTagDouble(Double.parseDouble(newValue));
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_BYTE_ARRAY(7){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagByteArray nbtTag = (NBTTagByteArray)currentNode.getData();
            nbtTagCompound.func_74773_a(currentNode.getTagName(), nbtTag.func_150292_c());
        }

        @Override
        String getValue(NBTBase currentTag) {
            byte[] byteArray = ((NBTTagByteArray)currentTag).func_150292_c();
            String value = "{";
            for (int i = 0; i < byteArray.length; ++i) {
                value = value.concat(Byte.toString(byteArray[i])).concat(",");
            }
            value = value.concat("}");
            return value;
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagByteArray nbtTag = (NBTTagByteArray)currentNBT;
            ArrayList<Byte> fillerByteArray = new ArrayList<Byte>();
            Scanner scanner = new Scanner(newValue);
            while (scanner.hasNextByte()) {
                fillerByteArray.add(scanner.nextByte());
            }
            scanner.close();
            byte[] resultByte = new byte[fillerByteArray.size()];
            for (int i = 0; i < fillerByteArray.size(); ++i) {
                resultByte[i] = (Byte)fillerByteArray.get(i);
            }
            return new NBTTagByteArray(resultByte);
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_STRING(8){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagString nbtTag = (NBTTagString)currentNode.getData();
            nbtTagCompound.func_74778_a(currentNode.getTagName(), nbtTag.func_150285_a_() != null ? nbtTag.func_150285_a_() : "");
        }

        @Override
        String getValue(NBTBase currentTag) {
            String string = ((NBTTagString)currentTag).func_150285_a_();
            return string != null ? string : "";
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagString nbtTag = (NBTTagString)currentNBT;
            return new NBTTagString(newValue);
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    TAG_LIST(9){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            ArrayList<NBTNode> children = new ArrayList<NBTNode>();
            NBTTagList nbtTagList = (NBTTagList)currentTag;
            List listOtags = ObfuscationHelper.getFieldFromReflection("field_74747_a", "tagList", (Object)nbtTagList, List.class);
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                children.add(new NBTNode((NBTBase)listOtags.get(i), currentNode, ""));
            }
            return children;
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagList oldTagList = (NBTTagList)currentNode.getData();
            NBTTagList newTagList = new NBTTagList();
            for (NBTNode childNode : currentNode.getChildren()) {
                NBTHelper helper = 10.getByID(childNode.getData().func_74732_a());
                helper.writeToTagList(newTagList, childNode);
            }
            nbtTagCompound.func_74782_a(currentNode.getTagName(), (NBTBase)newTagList);
        }

        @Override
        String getValue(NBTBase currentTag) {
            NBTTagList tagList = (NBTTagList)currentTag;
            String stringBuilder = "";
            List listOtags = ObfuscationHelper.getFieldFromReflection("field_74747_a", "tagList", (Object)tagList, List.class);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                stringBuilder = stringBuilder + "" + ":" + ((NBTBase)listOtags.get(i)).func_74732_a() + ",";
            }
            return stringBuilder;
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagList oldTagList = (NBTTagList)currentNBT;
            List listOtags = ObfuscationHelper.getFieldFromReflection("field_74747_a", "tagList", (Object)oldTagList, List.class);
            String[] newValueParts = newValue.split(",");
            NBTTagList newTagList = new NBTTagList();
            for (int i = 0; i < newValueParts.length; ++i) {
                String[] newValuePieces = newValueParts[i].split(":");
                if (i < oldTagList.func_74745_c()) {
                    newTagList.func_74742_a((NBTBase)listOtags.get(i));
                    continue;
                }
                String[] values = new String[newValuePieces.length - 2];
                for (int j = 2; j < values.length; ++j) {
                    values[j - 2] = newValuePieces[j];
                }
                newTagList.func_74742_a(10.createChildTag(Byte.parseByte(newValuePieces[1]), values));
            }
            return newTagList;
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            NBTTagList oldTagList = (NBTTagList)currentNode.getData();
            NBTTagList newTagList = new NBTTagList();
            for (NBTNode childNode : currentNode.getChildren()) {
                NBTHelper helper = 10.getByID(childNode.getData().func_74732_a());
                helper.writeToTagList(newTagList, childNode);
            }
            nbtTagList.func_74742_a((NBTBase)newTagList);
        }
    }
    ,
    TAG_COMPOUND(10){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            ArrayList<NBTNode> children = new ArrayList<NBTNode>();
            NBTTagCompound nbtTagList = (NBTTagCompound)currentTag;
            for (Object keyObject : nbtTagList.func_150296_c()) {
                String tagKey = (String)keyObject;
                NBTBase nbtBase = nbtTagList.func_74781_a(tagKey);
                children.add(new NBTNode(nbtBase, currentNode, tagKey));
            }
            return children;
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagCompound oldNBTTagCompound = (NBTTagCompound)currentNode.getData();
            NBTTagCompound newNBTTagCompound = new NBTTagCompound();
            for (NBTNode childNode : currentNode.getChildren()) {
                NBTHelper helper = 11.getByID(childNode.getData().func_74732_a());
                helper.writeToNBT(newNBTTagCompound, childNode);
            }
            nbtTagCompound.func_74782_a(currentNode.getTagName(), (NBTBase)newNBTTagCompound);
        }

        @Override
        String getValue(NBTBase currentTag) {
            NBTTagCompound tagCompound = (NBTTagCompound)currentTag;
            String stringBuilder = "";
            for (Object keyObject : tagCompound.func_150296_c()) {
                String tagKey = (String)keyObject;
                NBTBase nbtBase = tagCompound.func_74781_a(tagKey);
                stringBuilder = stringBuilder + tagKey + ":" + nbtBase.func_74732_a() + ",";
            }
            return stringBuilder;
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagCompound oldTagCompound = (NBTTagCompound)currentNBT;
            String[] newValueParts = newValue.split(",");
            NBTTagCompound newTagCompound = new NBTTagCompound();
            int numOldEntries = oldTagCompound.func_150296_c().size();
            ArrayList<NBTBase> oldNBT = new ArrayList<NBTBase>(numOldEntries);
            for (Object keyObject : oldTagCompound.func_150296_c()) {
                String tagKey = (String)keyObject;
                oldNBT.add(oldTagCompound.func_74781_a(tagKey));
            }
            for (int i = 0; i < newValueParts.length; ++i) {
                String[] newValuePieces = newValueParts[i].split(":");
                if (i < numOldEntries) {
                    newTagCompound.func_74782_a(newValuePieces[0], (NBTBase)oldNBT.get(i));
                    continue;
                }
                String[] values = new String[newValuePieces.length - 2];
                for (int j = 2; j < values.length; ++j) {
                    values[j - 2] = newValuePieces[j];
                }
                newTagCompound.func_74782_a(newValuePieces[0], 11.createChildTag(Byte.parseByte(newValuePieces[1]), values));
            }
            return newTagCompound;
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            NBTTagCompound oldTagCompound = (NBTTagCompound)currentNode.getData();
            NBTTagCompound newTagCompound = new NBTTagCompound();
            for (NBTNode childNode : currentNode.getChildren()) {
                NBTHelper helper = 11.getByID(childNode.getData().func_74732_a());
                helper.writeToNBT(newTagCompound, childNode);
            }
            nbtTagList.func_74742_a((NBTBase)newTagCompound);
        }
    }
    ,
    TAG_INT_ARRAY(11){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
            NBTTagIntArray nbtTag = (NBTTagIntArray)currentNode.getData();
            nbtTagCompound.func_74783_a(currentNode.getTagName(), nbtTag.func_150302_c());
        }

        @Override
        String getValue(NBTBase currentTag) {
            int[] intArray = ((NBTTagIntArray)currentTag).func_150302_c();
            String value = "{";
            for (int i = 0; i < intArray.length; ++i) {
                value = value.concat(Integer.toString(intArray[i])).concat(",");
            }
            value = value.concat("}");
            return value;
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            NBTTagIntArray nbtTag = (NBTTagIntArray)currentNBT;
            ArrayList<Integer> fillerIntArray = new ArrayList<Integer>();
            Scanner scanner = new Scanner(newValue);
            while (scanner.hasNextInt()) {
                fillerIntArray.add(scanner.nextInt());
            }
            scanner.close();
            int[] resultInt = new int[fillerIntArray.size()];
            for (int i = 0; i < fillerIntArray.size(); ++i) {
                resultInt[i] = (Integer)fillerIntArray.get(i);
            }
            return new NBTTagIntArray(resultInt);
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
            nbtTagList.func_74742_a(currentNode.getData());
        }
    }
    ,
    UNKNOWN(12){

        @Override
        ArrayList<NBTNode> getChildTags(NBTBase currentTag, NBTNode currentNode) {
            return new ArrayList<NBTNode>();
        }

        @Override
        void writeToNBT(NBTTagCompound nbtTagCompound, NBTNode currentNode) {
        }

        @Override
        String getValue(NBTBase currentTag) {
            return "";
        }

        @Override
        NBTBase getNBTFromString(NBTBase currentNBT, String newValue) {
            return null;
        }

        @Override
        void writeToTagList(NBTTagList nbtTagList, NBTNode currentNode) {
        }
    };

    public int iD;

    private NBTHelper(int iD) {
        this.iD = iD;
    }

    abstract ArrayList<NBTNode> getChildTags(NBTBase var1, NBTNode var2);

    abstract void writeToNBT(NBTTagCompound var1, NBTNode var2);

    abstract String getValue(NBTBase var1);

    abstract NBTBase getNBTFromString(NBTBase var1, String var2);

    abstract void writeToTagList(NBTTagList var1, NBTNode var2);

    public static NBTHelper getByID(int iD) {
        for (NBTHelper nbtHelper : NBTHelper.values()) {
            if (nbtHelper.iD != iD) continue;
            return nbtHelper;
        }
        return UNKNOWN;
    }

    public static NBTBase createChildTag(byte childtag, String ... values) {
        switch (childtag) {
            case 9: {
                return new NBTTagList();
            }
            case 10: {
                return new NBTTagCompound();
            }
            case 1: {
                return new NBTTagByte(Byte.parseByte(values[0].trim()));
            }
            case 2: {
                return new NBTTagShort(Short.parseShort(values[0].trim()));
            }
            case 3: {
                return new NBTTagInt(Integer.parseInt(values[0].trim()));
            }
            case 4: {
                return new NBTTagLong(Long.parseLong(values[0].trim()));
            }
            case 5: {
                return new NBTTagFloat(Float.parseFloat(values[0].trim()));
            }
            case 6: {
                return new NBTTagDouble(Double.parseDouble(values[0].trim()));
            }
            case 7: {
                byte[] byteArray = new byte[values.length];
                for (int i = 2; i < values.length; ++i) {
                    byteArray[i - 2] = (byte)ParsingHelper.parseFilteredInteger(values[i], 0, "ByteArray");
                }
                return new NBTTagByteArray(byteArray);
            }
            case 8: {
                return new NBTTagString("");
            }
            case 11: {
                int[] intArray = new int[values.length - 2];
                for (int i = 2; i < values.length; ++i) {
                    intArray[i - 2] = ParsingHelper.parseFilteredInteger(values[i], 0, "ByteArray");
                }
                return new NBTTagIntArray(intArray);
            }
        }
        ProjectZuluLog.severe("Unrecognised childtag tagId %s", childtag);
        throw new IllegalArgumentException();
    }
}

