/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.stek101.projectzulu.common.ProjectZulu_Core;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.packets.PZPacketPlaySound;
import com.stek101.projectzulu.common.dungeon.TileEntityLimitedMobSpawnData;
import com.stek101.projectzulu.common.dungeon.packets.PZPacketMobSpawner;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettingsSpawning;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public class TileEntityLimitedMobSpawner
extends TileEntity {
    public int delay = 20;
    private NBTTagCompound debugSavedSetup = new NBTTagCompound();
    private String mobID = "Chicken";
    private List<TileEntityLimitedMobSpawnData> spawnList = null;
    private TileEntityLimitedMobSpawnData spawnerTags = null;
    public double yaw;
    public double yaw2 = 0.0;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private Entity displayEntity;
    private boolean isEditable = true;
    private int maxSpawnableEntities = 5;
    private int spawnedEntities = 0;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRangeHorizontal = 4;
    private int spawnRangeVertical = 1;
    public int spawnRangeOffsetX = 0;
    public int spawnRangeOffsetY = 0;
    public int spawnRangeOffsetZ = 0;

    public boolean isDebugEnabled() {
        return this.debugSavedSetup != null && !this.debugSavedSetup.func_82582_d();
    }

    public void setDebugMode(NBTTagCompound debugSavedSetup) {
        this.debugSavedSetup = debugSavedSetup;
    }

    public void loadDebugNBT() {
        this.func_145839_a(this.debugSavedSetup);
    }

    public List<TileEntityLimitedMobSpawnData> getSpawnList() {
        return this.spawnList;
    }

    public void setSpawnList(List<TileEntityLimitedMobSpawnData> spawnList) {
        this.spawnList = spawnList;
    }

    public int getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    public int getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    public void setMinMaxSpawnDelay(int minSpawnDelay, int maxSpawnDelay) {
        if (maxSpawnDelay < minSpawnDelay) {
            this.maxSpawnDelay = minSpawnDelay;
            this.minSpawnDelay = minSpawnDelay;
        } else {
            this.maxSpawnDelay = maxSpawnDelay;
            this.minSpawnDelay = minSpawnDelay;
        }
    }

    public int getMaxSpawnableEntities() {
        return this.maxSpawnableEntities;
    }

    public void setMaxSpawnableEntities(int maxSpawnableEntities) {
        this.maxSpawnableEntities = maxSpawnableEntities;
    }

    public int getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    public int getRequriedPLayerRange() {
        return this.requiredPlayerRange;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public int getSpawnRangeHorizontal() {
        return this.spawnRangeHorizontal;
    }

    public int getSpawnRangeVertial() {
        return this.spawnRangeVertical;
    }

    public void setSpawnRangeHorizontal(int horizontal) {
        this.spawnRangeHorizontal = horizontal < 0 ? 0 : horizontal;
    }

    public void setSpawnRangeVertical(int vertical) {
        this.spawnRangeVertical = vertical < 0 ? 0 : vertical;
    }

    public String getEntityName() {
        return this.spawnerTags == null ? this.mobID : this.spawnerTags.type;
    }

    public void setMobID(String par1Str) {
        this.mobID = par1Str;
    }

    public boolean anyPlayerInRange() {
        if (this.isDebugEnabled()) {
            return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (double)this.requiredPlayerRange) != null;
        }
        return this.field_145850_b.func_72846_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (double)this.requiredPlayerRange) != null;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @SideOnly(value=Side.CLIENT)
    public void playSpawnSound(String spawnSound) {
        this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, spawnSound, 1.0f, 1.0f, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void setEditable(boolean par1) {
        this.isEditable = par1;
    }

    public void func_145845_h() {
        if (this.maxSpawnableEntities > 0 && this.spawnedEntities >= this.maxSpawnableEntities) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
        }
        if (this.anyPlayerInRange()) {
            if (this.field_145850_b.field_72995_K) {
                double var1 = (float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat();
                double var3 = (float)this.field_145848_d + this.field_145850_b.field_73012_v.nextFloat();
                double var5 = (float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat();
                this.field_145850_b.func_72869_a("smoke", var1, var3, var5, 0.0, 0.0, 0.0);
                this.field_145850_b.func_72869_a("flame", var1, var3, var5, 0.0, 0.0, 0.0);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.yaw2 = this.yaw;
                this.yaw = (this.yaw + (double)(1000.0f / ((float)this.delay + 200.0f))) % 360.0;
            } else {
                if (this.delay == -1) {
                    this.updateDelay();
                }
                if (this.delay > 0) {
                    --this.delay;
                    return;
                }
                boolean var12 = false;
                for (int var2 = 0; var2 < this.spawnCount; ++var2) {
                    Entity var13 = EntityList.func_75620_a((String)this.getEntityName(), (World)this.field_145850_b);
                    if (var13 == null) {
                        return;
                    }
                    int var4 = this.field_145850_b.func_72872_a(var13.getClass(), AxisAlignedBB.func_72330_a((double)(this.field_145851_c + this.spawnRangeOffsetX), (double)(this.field_145848_d + this.spawnRangeOffsetY), (double)(this.field_145849_e + this.spawnRangeOffsetZ), (double)(this.field_145851_c + this.spawnRangeOffsetX + 1), (double)(this.field_145848_d + this.spawnRangeOffsetY + 1), (double)(this.field_145849_e + this.spawnRangeOffsetZ + 1)).func_72314_b((double)(this.spawnRangeHorizontal * 2), (double)(this.spawnRangeVertical * 2 + 2), (double)(this.spawnRangeHorizontal * 2))).size();
                    if (var4 >= this.maxNearbyEntities) {
                        this.updateDelay();
                        return;
                    }
                    if (var13 == null) continue;
                    double var5 = (double)(this.field_145851_c + this.spawnRangeOffsetX) + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.spawnRangeHorizontal;
                    double var7 = (float)(this.field_145848_d + this.spawnRangeOffsetY + this.field_145850_b.field_73012_v.nextInt(this.spawnRangeVertical * 2 + 1)) - (float)this.spawnRangeVertical / 2.0f;
                    double var9 = (double)(this.field_145849_e + this.spawnRangeOffsetZ) + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.spawnRangeHorizontal;
                    EntityLiving var11 = var13 instanceof EntityLiving ? (EntityLiving)var13 : null;
                    this.writeNBTTagsTo(var13);
                    var13.func_70012_b(var5, var7, var9, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    boolean canSpawnHere = false;
                    canSpawnHere = this.spawnerTags != null && this.spawnerTags.optionalSpawning.isOptionalEnabled() ? this.optionalCanSpawnHere(var11, this.spawnerTags.optionalSpawning) : var11.func_70601_bi();
                    if (var11 != null && !canSpawnHere) continue;
                    this.field_145850_b.func_72838_d(var13);
                    this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
                    if (!this.isDebugEnabled()) {
                        ++this.spawnedEntities;
                    }
                    if (this.spawnerTags != null) {
                        PZPacketPlaySound message = new PZPacketPlaySound().setPacketData(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.spawnerTags.spawnSound);
                        ProjectZulu_Core.packetHandler.sendToAllAround(message, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
                    }
                    if (var11 != null) {
                        var11.func_70656_aK();
                    }
                    var12 = true;
                }
                if (var12) {
                    this.updateDelay();
                }
            }
            super.func_145845_h();
        }
    }

    private boolean optionalCanSpawnHere(EntityLiving entity, OptionalSettingsSpawning optionalSpawning) {
        boolean canSpawn = optionalSpawning.isOptionalEnabled() ? !optionalSpawning.isInverted() : false;
        int xCoord = MathHelper.func_76128_c((double)entity.field_70165_t);
        int yCoord = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
        int zCoord = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (!optionalSpawning.isValidLocation(entity.field_70170_p, entity, xCoord, yCoord, zCoord)) {
            canSpawn = optionalSpawning.isInverted();
        }
        return canSpawn && entity.field_70170_p.func_72855_b(entity.field_70121_D) && entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty();
    }

    public void writeNBTTagsTo(Entity par1Entity) {
        block9: {
            if (this.spawnerTags != null) {
                NBTTagCompound var2 = new NBTTagCompound();
                par1Entity.func_70039_c(var2);
                for (String key : this.spawnerTags.properties.func_150296_c()) {
                    NBTBase nbt = this.spawnerTags.properties.func_74781_a(key);
                    var2.func_74782_a(key, nbt.func_74737_b());
                }
                try {
                    par1Entity.func_70020_e(var2);
                }
                catch (Exception e) {
                    if (!this.debugSavedSetup.func_82582_d()) {
                        ProjectZuluLog.warning("Attempting to Recover From Debug Mode Backup due to Error %s", e.getMessage());
                        try {
                            this.loadDebugNBT();
                        }
                        catch (Exception e2) {
                            ProjectZuluLog.severe("Exception Occured when Writing DebugNBT to %s. Entity may not work as expected. Recreate NBT on entity can repair.", EntityList.func_75621_b((Entity)par1Entity));
                            e2.printStackTrace();
                        }
                        break block9;
                    }
                    ProjectZuluLog.severe("Exception occured when writing NBT to Entity %s. Entity may not work as expected. Recreate NBT on entity can repair.", EntityList.func_75621_b((Entity)par1Entity));
                    e.printStackTrace();
                }
            } else if (par1Entity instanceof EntityLiving && par1Entity.field_70170_p != null) {
                Object var2_3 = null;
            }
        }
    }

    private void updateDelay() {
        this.delay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.field_145850_b.field_73012_v.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        if (this.spawnList != null && this.spawnList.size() > 0) {
            this.spawnerTags = (TileEntityLimitedMobSpawnData)WeightedRandom.func_76271_a((Random)this.field_145850_b.field_73012_v, this.spawnList);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 0);
    }

    public void forceUpdate() {
        this.updateDelay();
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.mobID = par1NBTTagCompound.func_74779_i("EntityId");
        this.delay = par1NBTTagCompound.func_74765_d("Delay");
        if (par1NBTTagCompound.func_74764_b("SpawnPotentials")) {
            this.spawnList = new ArrayList<TileEntityLimitedMobSpawnData>();
            NBTTagList var2 = par1NBTTagCompound.func_150295_c("SpawnPotentials", 10);
            for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
                TileEntityLimitedMobSpawnData spawnData = new TileEntityLimitedMobSpawnData(this, var2.func_150305_b(var3));
                if (EntityList.field_75625_b.containsKey(spawnData.type)) {
                    this.spawnList.add(spawnData);
                    continue;
                }
                ProjectZuluLog.severe("Failed to load Limited Spawner entity %s at (%s, %s, %s). Entity does not appear to be declared.", spawnData.type, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.spawnList = null;
        }
        if (par1NBTTagCompound.func_74764_b("SpawnData")) {
            this.spawnerTags = new TileEntityLimitedMobSpawnData(this, par1NBTTagCompound.func_74775_l("SpawnData"), this.mobID, "", "");
            if (!EntityList.field_75626_c.containsKey(this.spawnerTags.type)) {
                ProjectZuluLog.severe("Failed to load Limited Spawner entity %s at (%s, %s, %s). Entity does not appear to be declared.", this.spawnerTags.type, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.spawnerTags = null;
        } else {
            this.spawnerTags = null;
        }
        if (par1NBTTagCompound.func_74764_b("MinSpawnDelay")) {
            this.minSpawnDelay = par1NBTTagCompound.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = par1NBTTagCompound.func_74765_d("MaxSpawnDelay");
            this.spawnCount = par1NBTTagCompound.func_74765_d("SpawnCount");
            this.maxSpawnableEntities = par1NBTTagCompound.func_74765_d("MaxSpawnableEntities");
        }
        if (par1NBTTagCompound.func_74764_b("MaxNearbyEntities")) {
            this.maxNearbyEntities = par1NBTTagCompound.func_74765_d("MaxNearbyEntities");
            this.requiredPlayerRange = par1NBTTagCompound.func_74765_d("RequiredPlayerRange");
        }
        if (par1NBTTagCompound.func_74764_b("SpawnRangeHori")) {
            this.spawnRangeHorizontal = par1NBTTagCompound.func_74765_d("SpawnRangeHori");
        } else if (par1NBTTagCompound.func_74764_b("SpawnRange")) {
            this.spawnRangeHorizontal = par1NBTTagCompound.func_74765_d("SpawnRange");
        }
        if (par1NBTTagCompound.func_74764_b("SpawnRangeVert")) {
            this.spawnRangeVertical = par1NBTTagCompound.func_74765_d("SpawnRangeVert");
        }
        if (par1NBTTagCompound.func_74764_b("DebugSavedSetup")) {
            this.debugSavedSetup = par1NBTTagCompound.func_74775_l("DebugSavedSetup");
        }
        if (par1NBTTagCompound.func_74764_b("OffsetX")) {
            this.spawnRangeOffsetX = par1NBTTagCompound.func_74765_d("OffsetX");
        }
        if (par1NBTTagCompound.func_74764_b("OffsetY")) {
            this.spawnRangeOffsetY = par1NBTTagCompound.func_74765_d("OffsetY");
        }
        if (par1NBTTagCompound.func_74764_b("OffsetZ")) {
            this.spawnRangeOffsetZ = par1NBTTagCompound.func_74765_d("OffsetZ");
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.displayEntity = null;
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74782_a("DebugSavedSetup", (NBTBase)this.debugSavedSetup);
        par1NBTTagCompound.func_74778_a("EntityId", this.getEntityName());
        par1NBTTagCompound.func_74777_a("Delay", (short)this.delay);
        par1NBTTagCompound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        par1NBTTagCompound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        par1NBTTagCompound.func_74777_a("SpawnCount", (short)this.spawnCount);
        par1NBTTagCompound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        par1NBTTagCompound.func_74777_a("RequiredPlayerRange", (short)this.requiredPlayerRange);
        par1NBTTagCompound.func_74777_a("SpawnRangeHori", (short)this.spawnRangeHorizontal);
        par1NBTTagCompound.func_74777_a("SpawnRangeVert", (short)this.spawnRangeVertical);
        par1NBTTagCompound.func_74777_a("MaxSpawnableEntities", (short)this.maxSpawnableEntities);
        par1NBTTagCompound.func_74777_a("OffsetX", (short)this.spawnRangeOffsetX);
        par1NBTTagCompound.func_74777_a("OffsetY", (short)this.spawnRangeOffsetY);
        par1NBTTagCompound.func_74777_a("OffsetZ", (short)this.spawnRangeOffsetZ);
        if (this.spawnerTags != null) {
            par1NBTTagCompound.func_74782_a("SpawnData", (NBTBase)((NBTTagCompound)this.spawnerTags.properties.func_74737_b()));
        }
        if (this.spawnerTags != null || this.spawnList != null && this.spawnList.size() > 0) {
            NBTTagList var2 = new NBTTagList();
            if (this.spawnList != null && this.spawnList.size() > 0) {
                for (TileEntityLimitedMobSpawnData var4 : this.spawnList) {
                    var2.func_74742_a((NBTBase)var4.getNBT());
                }
            } else {
                var2.func_74742_a((NBTBase)this.spawnerTags.getNBT());
            }
            par1NBTTagCompound.func_74782_a("SpawnPotentials", (NBTBase)var2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getMobEntity() {
        if (this.displayEntity == null) {
            Entity var1 = EntityList.func_75620_a((String)this.getEntityName(), (World)Minecraft.func_71410_x().field_71441_e);
            this.writeNBTTagsTo(var1);
            this.displayEntity = var1;
        }
        return this.displayEntity;
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public void syncToServer() {
        NBTTagCompound tileEntityData = new NBTTagCompound();
        this.func_145841_b(tileEntityData);
        PZPacketMobSpawner message = new PZPacketMobSpawner().setPacketData(this.field_145851_c, this.field_145848_d, this.field_145849_e, tileEntityData);
        ProjectZulu_Core.packetHandler.sendToServer(message);
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1 && this.field_145850_b.field_72995_K) {
            this.delay = this.minSpawnDelay;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }
}

