/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag;

import com.stek101.projectzulu.common.core.ProjectZuluLog;

public class ParsingHelper {
    public static int parseInteger(String value, int fallBack, String fieldName) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (fieldName != null) {
                ProjectZuluLog.warning("Error Parsing %s for an integer. %s was unreadable. The Default value of %s will be used.", value, fieldName, fallBack);
            } else {
                ProjectZuluLog.warning("Error Parsing %s for an integer. The Default value of %s will be used.", value, fallBack);
            }
            return fallBack;
        }
    }

    public static int parseFilteredInteger(String value, int fallBack, String fieldName) {
        try {
            return Integer.parseInt(value.replaceAll("[^\\d-]", ""));
        }
        catch (NumberFormatException e) {
            if (fieldName != null) {
                ProjectZuluLog.warning("Error Parsing %s for an integer. %s was unreadable. The Default value of %s will be used.", value, fieldName, fallBack);
            } else {
                ProjectZuluLog.warning("Error Parsing %s for an integer. The Default value of %s will be used.", value, fallBack);
            }
            return fallBack;
        }
    }

    public static Long parseFilteredLong(String value, Long fallBack, String fieldName) {
        try {
            return Long.parseLong(value.replaceAll("[^\\d-]", ""));
        }
        catch (NumberFormatException e) {
            if (fieldName != null) {
                ProjectZuluLog.warning("Error Parsing %s for an long. %s was unreadable. The Default value of %s will be used.", value, fieldName, fallBack);
            } else {
                ProjectZuluLog.warning("Error Parsing %s for an long. The Default value of %s will be used.", value, fallBack);
            }
            return fallBack;
        }
    }

    public static float parseFilteredFloat(String value, float fallBack, String fieldName) {
        try {
            return Float.parseFloat(value.replaceAll("[^\\d.-]", ""));
        }
        catch (NumberFormatException e) {
            if (fieldName != null) {
                ProjectZuluLog.warning("Error Parsing %s for an double. %s was unreadable. The Default value of %s will be used.", value, fieldName, Float.valueOf(fallBack));
            } else {
                ProjectZuluLog.warning("Error Parsing %s for an double. The Default value of %s will be used.", value, Float.valueOf(fallBack));
            }
            return fallBack;
        }
    }

    public static double parseFilteredDouble(String value, double fallBack, String fieldName) {
        try {
            return Double.parseDouble(value.replaceAll("[^\\d.-]", ""));
        }
        catch (NumberFormatException e) {
            if (fieldName != null) {
                ProjectZuluLog.warning("Error Parsing %s for an double. %s was unreadable. The Default value of %s will be used.", value, fieldName, fallBack);
            } else {
                ProjectZuluLog.warning("Error Parsing %s for an double. The Default value of %s will be used.", value, fallBack);
            }
            return fallBack;
        }
    }

    public static boolean parseBoolean(String value, boolean fallBack, String fieldName) {
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            if (fieldName != null) {
                ProjectZuluLog.warning("Error Parsing %s for a boolean. %s was unreadable. The Default value of %s will be used.", value, fieldName, fallBack);
            } else {
                ProjectZuluLog.warning("Error Parsing %s for a boolean. The Default value of %s will be used.", value, fallBack);
            }
            return fallBack;
        }
        return Boolean.parseBoolean(value);
    }
}

