/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBlock;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBlockFoot;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBlockRange;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserDespawn;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserDespawnAge;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserDifficulty;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserEntities;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserEntityCap;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserFill;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserGround;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserLight;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserLiquid;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserMaxHeight;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserMaxSpawnRange;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserMinHeight;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserModSpawn;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserNormalCube;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserOpaqueBlock;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserOrigin;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserPlayers;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserRandom;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserSky;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserSolidSide;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserSpawn;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserSpawnRange;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserSpawnRate;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserTop;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserTorchLight;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserWriteNBT;
import java.util.EnumSet;
import java.util.HashMap;

public enum Key {
    spawn("spawn", KeyParserSpawn.class),
    despawn("despawn", KeyParserDespawn.class),
    sky("sky", KeyParserSky.class),
    block("block", KeyParserBlock.class),
    blockFoot("blockFoot", KeyParserBlockFoot.class),
    light("light", KeyParserLight.class),
    entityCap("cap", KeyParserEntityCap.class),
    spawnRange("spawnRange", KeyParserSpawnRange.class),
    maxSpawnRange("maxSpawnRange", KeyParserMaxSpawnRange.class),
    despawnAge("despawnAge", KeyParserDespawnAge.class),
    spawnRate("spawnRate", KeyParserSpawnRate.class),
    blockRange("blockRange", KeyParserBlockRange.class),
    material("material", null),
    minSpawnHeight("minSpawnHeight", KeyParserMinHeight.class),
    maxSpawnHeight("maxSpawnHeight", KeyParserMaxHeight.class),
    normal("normal", KeyParserNormalCube.class),
    liquid("liquid", KeyParserLiquid.class),
    opaque("opaque", KeyParserOpaqueBlock.class),
    solidSide("solidSide", KeyParserSolidSide.class),
    difficulty("difficulty", KeyParserDifficulty.class),
    torchLight("torchLight", KeyParserTorchLight.class),
    ground("ground", KeyParserGround.class),
    top("top", KeyParserTop.class),
    fill("fill", KeyParserFill.class),
    modspawn("modSpawn", KeyParserModSpawn.class),
    origin("origin", KeyParserOrigin.class),
    players("players", KeyParserPlayers.class),
    entities("entities", KeyParserEntities.class),
    random("random", KeyParserRandom.class),
    writenbt("writenbt", KeyParserWriteNBT.class),
    blockRangeX("blockRangeX", null),
    blockRangeY("blockRangeY", null),
    blockRangeZ("blockRangeZ", null),
    UNKNOWN("", null);

    public final String key;
    private static final HashMap<String, Key> lookupEnum;
    public KeyParser keyParser;

    private Key(String key, Class<? extends KeyParser> keyParserClass) {
        this.key = key;
        if (keyParserClass != null) {
            try {
                this.keyParser = keyParserClass.getConstructor(Key.class).newInstance(new Object[]{this});
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public static Key getKeybyString(String string) {
        Key value = lookupEnum.get(string.toUpperCase());
        if (value != null) {
            return value;
        }
        return UNKNOWN;
    }

    static {
        lookupEnum = new HashMap();
        for (Key key : EnumSet.allOf(Key.class)) {
            lookupEnum.put(key.key.toUpperCase(), key);
        }
    }
}

