/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class KeyParserDifficulty
extends KeyParserBase {
    public KeyParserDifficulty(Key key) {
        super(key, true, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        int difficulty;
        String[] pieces = parseable.split(",");
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        boolean isInverted = false;
        if (this.isInverted(parseable)) {
            isInverted = true;
        }
        if ((difficulty = ParsingHelper.parseFilteredInteger(pieces[1], 0, this.key.key)) < 0 || difficulty > 3) {
            ProjectZuluLog.info("Difficulty must be between 0 (Peaceful) and 3 (Hard)", new Object[0]);
            return false;
        }
        TypeValuePair typeValue = new TypeValuePair(this.key, new Object[]{isInverted, difficulty});
        if (typeValue.getValue() != null) {
            parsedChainable.add(typeValue);
            operandvalue.add(operand);
            return true;
        }
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        Object[] values = (Object[])typeValuePair.getValue();
        Boolean isInverted = (Boolean)values[0];
        Integer difficulty = (Integer)values[1];
        return (isInverted != false || !difficulty.equals(world.field_73013_u)) && (isInverted == false || difficulty.equals(world.field_73013_u));
    }
}

