/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class KeyParserSolidSide
extends KeyParserBase {
    public KeyParserSolidSide(Key key) {
        super(key, true, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        boolean isInverted = false;
        if (this.isInverted(parseable)) {
            isInverted = true;
        }
        String[] pieces = parseable.split(",");
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        TypeValuePair typeValue = null;
        if (pieces.length == 3 || pieces.length == 4) {
            int side = ParsingHelper.parseFilteredInteger(pieces[1], 0, "side");
            int rangeZ = 0;
            int rangeY = 0;
            int rangeX = 0;
            String[] rangePieces = pieces[2].split("/");
            if (rangePieces.length == 3) {
                rangeX = ParsingHelper.parseFilteredInteger(rangePieces[0], 0, this.key.key + "BlockRangeX");
                rangeY = ParsingHelper.parseFilteredInteger(rangePieces[1], 0, this.key.key + "BlockRangeY");
                rangeZ = ParsingHelper.parseFilteredInteger(rangePieces[2], 0, this.key.key + "BlockRangeZ");
            } else if (rangePieces.length == 1) {
                rangeY = rangeX = ParsingHelper.parseFilteredInteger(rangePieces[0], 0, this.key.key + "BlockRange");
                rangeZ = rangeX;
            } else {
                ProjectZuluLog.severe("Error Parsing Range of %s. Invalid Argument Length of %s.", this.key.key, rangePieces.length);
            }
            if (pieces.length == 4) {
                String[] offsetPieces = pieces[3].split("/");
                int offsetX = ParsingHelper.parseFilteredInteger(offsetPieces[0], 0, this.key.key + "OffsetX");
                int offsetY = ParsingHelper.parseFilteredInteger(offsetPieces[1], 0, this.key.key + "OffsetY");
                int offsetZ = ParsingHelper.parseFilteredInteger(offsetPieces[2], 0, this.key.key + "OffsetZ");
                typeValue = new TypeValuePair(this.key, new Object[]{isInverted, side, rangeX, rangeY, rangeZ, offsetX, offsetY, offsetZ});
            } else {
                typeValue = new TypeValuePair(this.key, new Object[]{isInverted, side, rangeX, rangeY, rangeZ});
            }
        } else {
            ProjectZuluLog.severe("Error Parsing %s Block Parameter. Invalid Argument Length of %s.", this.key.key, pieces.length);
            return false;
        }
        if (typeValue != null && typeValue.getValue() != null) {
            parsedChainable.add(typeValue);
            operandvalue.add(operand);
            return true;
        }
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        Object[] values = (Object[])typeValuePair.getValue();
        boolean isInverted = (Boolean)values[0];
        int side = (Integer)values[1];
        if (values.length == 5 || values.length == 8) {
            int rangeX = (Integer)values[2];
            int rangeY = (Integer)values[3];
            int rangeZ = (Integer)values[4];
            int offsetZ = 0;
            int offsetY = 0;
            int offsetX = 0;
            if (values.length == 8) {
                offsetX = (Integer)values[5];
                offsetY = (Integer)values[6];
                offsetZ = (Integer)values[7];
            }
            for (int i = -rangeX; i <= rangeX; ++i) {
                for (int k = -rangeZ; k <= rangeZ; ++k) {
                    for (int j = -rangeY; j <= rangeY; ++j) {
                        boolean isSolid = world.func_147439_a(xCoord + offsetX + i, yCoord + offsetY + j, zCoord + offsetZ + k).isSideSolid((IBlockAccess)world, xCoord + offsetX + i, yCoord + offsetY + j, zCoord + offsetZ + k, ForgeDirection.getOrientation((int)side));
                        if ((isInverted || !isSolid) && (!isInverted || isSolid)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

