/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.NBTWriter;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class KeyParserWriteNBT
extends KeyParserBase {
    public KeyParserWriteNBT(Key key) {
        super(key, false, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        String[] pieces = parseable.split(",", 2);
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        if (pieces.length > 1) {
            TypeValuePair typeValue = new TypeValuePair(this.key, pieces[1]);
            parsedChainable.add(typeValue);
            operandvalue.add(operand);
            return true;
        }
        ProjectZuluLog.severe("Error Parsing %s Parameter. Invalid Argument Length.", this.key.key);
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        String nbtOperation = (String)typeValuePair.getValue();
        try {
            NBTTagCompound entityNBT = new NBTTagCompound();
            entity.func_70109_d(entityNBT);
            new NBTWriter(nbtOperation).writeToNBT(entityNBT);
            entity.func_70020_e(entityNBT);
            return false;
        }
        catch (IllegalFormatException e) {
            ProjectZuluLog.severe("Skipping NBT Write due to %s", e.getMessage());
            return true;
        }
        catch (IllegalArgumentException e) {
            ProjectZuluLog.severe("Skipping NBT Write due to %s", e.getMessage());
            return true;
        }
    }
}

