/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entity;

import com.stek101.projectzulu.common.api.BlockList;
import com.stek101.projectzulu.common.core.DefaultProps;
import com.stek101.projectzulu.common.mobs.entity.EntityGenericAnimal;
import com.stek101.projectzulu.common.mobs.entity.EntityModelRotation;
import com.stek101.projectzulu.common.mobs.entity.EntityStates;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIAttackOnCollide;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIFollowParent;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIHurtByTarget;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIMate;
import com.stek101.projectzulu.common.mobs.entityai.EntityAINearestAttackableTarget;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIPanic;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIStayStill;
import com.stek101.projectzulu.common.mobs.entityai.EntityAITempt;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIWander;
import cpw.mods.fml.common.Loader;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityArmadillo
extends EntityGenericAnimal
implements IAnimals {
    public static final UUID field_110179_h = UUID.fromString("E199AD22-BA8B-4C53-8A13-1182D5C69D3A");
    public static final AttributeModifier CHARGING_BONUS = new AttributeModifier(field_110179_h, "Fleeing speed bonus", -0.3, 2).func_111168_a(false);
    public EntityModelRotation eWHOLE = new EntityModelRotation();
    public EntityModelRotation eHEADPIECE = new EntityModelRotation();
    public EntityModelRotation eREARRTR1 = new EntityModelRotation();
    public EntityModelRotation eREARRTR2 = new EntityModelRotation();
    public EntityModelRotation eREARRTR3 = new EntityModelRotation();
    public EntityModelRotation etail = new EntityModelRotation();
    public EntityModelRotation eleg3 = new EntityModelRotation();
    public EntityModelRotation eleg4 = new EntityModelRotation();
    int ticksToCheckAbilities = 3;
    int inCoverTimer = 0;
    static final int inCoverTimerMax = 20;
    protected boolean isCharging = false;
    protected float timeSinceLastCharge = 5.0f;
    protected float chargeTriggerThreshold = 200.0f + (float)this.field_70146_Z.nextInt(200);
    protected float chargeTime = 0.2f * this.chargeTriggerThreshold;
    protected int chargeSpeedModifier = 2;

    public boolean isCharging() {
        return this.isCharging;
    }

    public EntityArmadillo(World par1World) {
        super(par1World);
        this.field_70121_D.func_72324_b(-0.05, -0.05, -0.15, 0.05, 1.8, 0.15);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic(this, 1.25f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIStayStill(this, EntityStates.inCover));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide(this, 1.0f, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate(this, 1.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt(this, 1.2f, Items.field_151070_bp, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowParent(this, 1.1f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander(this, 1.0f, 120));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget(this, false, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget(this, EnumSet.of(EntityStates.attacking, EntityStates.looking), EntityPlayer.class, 16.0f, 0, true));
    }

    @Override
    protected boolean isValidLocation(World world, int xCoord, int yCoord, int zCoord) {
        return super.isValidLocation(world, xCoord, yCoord, zCoord) && this.field_70170_p.func_72937_j(xCoord, yCoord, zCoord);
    }

    public int func_70658_aO() {
        if (this.getEntityState() == EntityStates.inCover) {
            return 30;
        }
        return 4;
    }

    protected String func_70639_aQ() {
        return "projectzulumob:" + DefaultProps.entitySounds + "armadilloliving";
    }

    public int func_70627_aG() {
        return 160;
    }

    @Override
    public void updateAIState() {
        if (this.inCoverTimer > 0) {
            this.entityState = EntityStates.inCover;
        } else {
            super.updateAIState();
        }
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.field_70173_aa % this.ticksToCheckAbilities == 0) {
            EntityPlayer tempE = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            boolean canSee = false;
            boolean isFacing = false;
            if (tempE != null) {
                double angleEntToPlayer = Math.atan2(this.field_70165_t - tempE.field_70165_t, tempE.field_70161_v - this.field_70161_v) * 57.29577951308232 + 180.0;
                double playerRotationYaw = tempE.field_70177_z;
                double difference = Math.abs(MathHelper.func_76138_g((double)(this.normalizeTo360(angleEntToPlayer) - this.normalizeTo360(playerRotationYaw))));
                if (difference < 90.0) {
                    isFacing = true;
                }
                canSee = this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)tempE.field_70165_t, (double)(tempE.field_70163_u + (double)tempE.func_70047_e()), (double)tempE.field_70161_v), Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v)) == null;
            }
            this.inCoverTimer = tempE == null || !canSee || !tempE.func_71039_bw() || !isFacing || tempE.field_71071_by.func_70448_g().func_77973_b() != Items.field_151031_f ? Math.max(this.inCoverTimer - this.ticksToCheckAbilities, 0) : 20;
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.field_70173_aa % 200 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.field_70173_aa % this.ticksToCheckAbilities == 0) {
            if (this.timeSinceLastCharge > this.chargeTriggerThreshold && !this.isCharging) {
                this.isCharging = true;
                this.timeSinceLastCharge = 0.0f;
                this.chargeTriggerThreshold = 200.0f + (float)this.field_70146_Z.nextInt(200);
            }
            if (this.isCharging && this.timeSinceLastCharge > this.chargeTime) {
                this.isCharging = false;
            }
            this.timeSinceLastCharge += (float)this.ticksToCheckAbilities;
        }
        super.func_70636_d();
    }

    public float func_70689_ay() {
        float baseSpeed = super.func_70689_ay();
        return this.isCharging ? baseSpeed * (float)this.chargeSpeedModifier : baseSpeed;
    }

    private double normalizeTo360(double angle) {
        while (angle < 0.0 || angle > 360.0) {
            if (angle < 0.0) {
                angle += 360.0;
            }
            if (!(angle > 360.0)) continue;
            angle -= 360.0;
        }
        return angle;
    }

    @Override
    public boolean isValidBreedingItem(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() == Items.field_151070_bp) {
            return true;
        }
        return super.isValidBreedingItem(itemStack);
    }

    protected void func_70600_l(int par1) {
        if (Loader.isModLoaded((String)"ProjectZulu|Block") && BlockList.mobHeads.isPresent()) {
            this.func_70099_a(new ItemStack((Block)BlockList.mobHeads.get(), 1, 2), 1.0f);
        }
        super.func_70600_l(par1);
    }
}

