/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityBeetleBS;
import com.stek101.projectzulu.common.mobs.models.ModelBeetleBS;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLivingMT;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class BeetleBSDeclaration
extends SpawnableDeclaration {
    private final List<String> entityTextures = new ArrayList<String>();

    public BeetleBSDeclaration() {
        super("BeetleBS", 63, EntityBeetleBS.class, EnumCreatureType.ambient);
        this.setSpawnProperties(10, 5, 1, 1);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 1);
        this.eggColor1 = 6645135;
        this.eggColor2 = 14843392;
        this.entityTextures.add("textures/beetlebs1.png");
        this.entityTextures.add("textures/beetlebs2.png");
        this.entityTextures.add("textures/beetlebs3.png");
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        customMobData.entityProperties = new EntityProperties(1.0f, 0.0f, 0.15f).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLivingMT((ModelBase)new ModelBeetleBS(), 0.5f, this.entityTextures);
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        defaultBiomesToSpawn.add("Autumn Woods");
        defaultBiomesToSpawn.add("Birch Forest");
        defaultBiomesToSpawn.add("Forested Hills");
        defaultBiomesToSpawn.add("Forested Island");
        defaultBiomesToSpawn.add("Green Hills");
        defaultBiomesToSpawn.add("Redwood Forest");
        defaultBiomesToSpawn.add("Lush Redwoods");
        defaultBiomesToSpawn.add("Temperate Rainforest");
        defaultBiomesToSpawn.add("Woodlands");
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.PLAINS));
        nonFrozenForest.removeAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

