/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityGoat;
import com.stek101.projectzulu.common.mobs.models.ModelGoat;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLivingMT;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class GoatDeclaration
extends SpawnableDeclaration {
    private final List<String> goatTextures = new ArrayList<String>();

    public GoatDeclaration() {
        super("Goat", 45, EntityGoat.class, EnumCreatureType.creature);
        this.setSpawnProperties(10, 100, 1, 3);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 2);
        this.eggColor1 = 0x989898;
        this.eggColor2 = 10380054;
        this.goatTextures.add("textures/goat0.png");
        this.goatTextures.add("textures/goat1.png");
        this.goatTextures.add("textures/goat2.png");
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.muttonRaw, 0, 2);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.furPelt, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.SmallHeart.meta(), 5);
        customMobData.entityProperties = new EntityProperties(9.0f, 2.0f, 0.3f, 0.0f, 0.5f, 32.0f, 20.0f, 16.0).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLivingMT((ModelBase)new ModelGoat(), 0.5f, this.goatTextures);
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76768_g.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76784_u.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_150582_Q.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_150582_Q.field_76791_y);
        defaultBiomesToSpawn.add("Alpine");
        defaultBiomesToSpawn.add("Mountain Taiga");
        defaultBiomesToSpawn.add("Snowy Rainforest");
        HashSet<String> frozenForest = new HashSet<String>();
        frozenForest.addAll(this.typeToArray(BiomeDictionary.Type.PLAINS));
        frozenForest.addAll(this.typeToArray(BiomeDictionary.Type.HILLS));
        frozenForest.retainAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(frozenForest);
        return defaultBiomesToSpawn;
    }
}

