/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.architect;

import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.CellHelper;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectBase;
import com.stek101.projectzulu.common.world2.architect.BlueprintSetStockpile;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericCardinal;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericCarved;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericEdge;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericLimited;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericUncarved;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import com.stek101.projectzulu.common.world2.blueprints.oasis.BPOasisEdgeDiagonal;
import com.stek101.projectzulu.common.world2.blueprints.oasis.BPOasisEdgeRandomMid;
import com.stek101.projectzulu.common.world2.blueprints.oasis.BPOasisEdgeRandomPoint;
import com.stek101.projectzulu.common.world2.blueprints.oasis.BPOasisGrass;
import com.stek101.projectzulu.common.world2.blueprints.oasis.BPOasisPool;
import com.stek101.projectzulu.common.world2.blueprints.oasis.BPOasisSandCorner;
import com.stek101.projectzulu.common.world2.blueprints.oasis.BPOasisTreeGrass;
import java.awt.Point;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class ArchitectOasis
extends ArchitectBase {
    BlueprintSetStockpile edgeStockpile;
    BPSetGenericCarved sandCorner = new BPSetGenericCarved(new BPOasisSandCorner());

    public ArchitectOasis(World world) {
        super(world);
        this.edgeStockpile = new BlueprintSetStockpile(world.field_73012_v);
        this.edgeStockpile.addBlueprintSet(new BPSetGenericEdge(new BPOasisEdgeRandomPoint()));
        this.edgeStockpile.addBlueprintSet(new BPSetGenericEdge(new BPOasisEdgeDiagonal(false)));
        this.edgeStockpile.addBlueprintSet(new BPSetGenericEdge(new BPOasisEdgeDiagonal(true)));
        this.edgeStockpile.addBlueprintSet(new BPSetGenericEdge(new BPOasisEdgeRandomMid(false)));
        this.edgeStockpile.addBlueprintSet(new BPSetGenericEdge(new BPOasisEdgeRandomMid(true)));
        this.edgeStockpile.addBlueprintSet(this.sandCorner);
        this.stockpile.addBlueprintSet(new BPSetGenericUncarved(new BPOasisPool()));
        this.stockpile.addBlueprintSet(new BPSetGenericCardinal(new BPOasisGrass(), 1));
        this.stockpile.addBlueprintSet(new BPSetGenericLimited(new BPOasisTreeGrass(), 1, 3));
    }

    @Override
    public void assignBlueprint(MazeCell[][] cells, Point buildCoords, int pass, int maxPass) {
        BlueprintSet set = null;
        if (CellHelper.isCorner(cells, buildCoords)) {
            set = this.sandCorner;
        }
        if (set == null) {
            set = this.edgeStockpile.getRandomApplicable(cells, buildCoords);
        }
        if (set == null) {
            set = this.stockpile.getRandomApplicable(cells, buildCoords);
        }
        if (set != null) {
            set.assignCellsWithBlueprints(cells, buildCoords, this.random);
        }
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(MazeCell cell, ChunkCoordinates piecePos) {
        BlueprintSet set = this.edgeStockpile.getBlueprintSet(cell);
        if (set != null) {
            return this.edgeStockpile.getBlueprintSet(cell).getBlockFromBlueprint(piecePos, cell.size, cell.getHeight(), cell.getDirection(), this.random, cell.getBuildingID());
        }
        set = this.stockpile.getBlueprintSet(cell);
        if (set != null) {
            return this.stockpile.getBlueprintSet(cell).getBlockFromBlueprint(piecePos, cell.size, cell.getHeight(), cell.getDirection(), this.random, cell.getBuildingID());
        }
        return null;
    }
}

