/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;

public class BPSetGenericEdge
implements BlueprintSet {
    Blueprint blueprint;

    public BPSetGenericEdge(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    @Override
    public boolean assignCellsWithBlueprints(MazeCell[][] cells, Point buildCoords, Random random) {
        if (buildCoords.y == 0) {
            if (buildCoords.x == 0) {
                cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.NorthWestCorner);
            } else if (buildCoords.x == cells.length - 1) {
                cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.NorthEastCorner);
            } else {
                cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.NorthWall);
            }
            return true;
        }
        if (buildCoords.y == cells[0].length - 1) {
            if (buildCoords.x == 0) {
                cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.SouthWestCorner);
            } else if (buildCoords.x == cells.length - 1) {
                cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.SouthEastCorner);
            } else {
                cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.SouthWall);
            }
            return true;
        }
        if (buildCoords.x == 0) {
            cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.WestWall);
            return true;
        }
        if (buildCoords.x == cells.length - 1) {
            cells[buildCoords.x][buildCoords.y].setBuildingProperties(this.getIdentifier(), CellIndexDirection.EastWall);
            return true;
        }
        return false;
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, String buildingID) {
        return this.blueprint.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
    }

    @Override
    public boolean isApplicable(MazeCell[][] cells, Point buildCoords, Random random) {
        return buildCoords.x == 0 || buildCoords.x == cells.length - 1 || buildCoords.y == 0 || buildCoords.y == cells[0].length - 1;
    }

    @Override
    public String getIdentifier() {
        return this.blueprint.getIdentifier();
    }

    @Override
    public int getWeight() {
        return this.blueprint.getWeight();
    }
}

