/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint;

import com.stek101.projectzulu.common.ProjectZulu_Core;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world.dataobjects.ChestWithMeta;
import com.stek101.projectzulu.common.world.dataobjects.MobSpawnerWithMeta;
import com.stek101.projectzulu.common.world.terrain.LabyrinthFeature;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;

public class BlueprintLabyrinthHiddenWall
implements Blueprint {
    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        if (piecePos.field_71572_b == 0 || piecePos.field_71572_b == cellHeight - 1) {
            return new BlockWithMeta(Blocks.field_150417_aV, 0);
        }
        if (piecePos.field_71574_a == cellSize / 2 && piecePos.field_71573_c == cellSize / 2) {
            if (piecePos.field_71572_b == 1) {
                LabyrinthFeature feature = (LabyrinthFeature)ProjectZulu_Core.featureGenerator.getRegisteredStructure("Labyrinth");
                String entityName = feature.getEntityEntry(random);
                if (EntityList.field_75625_b.containsKey(entityName)) {
                    return new MobSpawnerWithMeta(entityName);
                }
                if (!entityName.equalsIgnoreCase("EMPTY")) {
                    ProjectZuluLog.severe("Entity with name %s does not seem to exist.", entityName);
                }
                return new BlockWithMeta(Blocks.field_150417_aV, 2);
            }
            if (piecePos.field_71572_b == 2) {
                LabyrinthFeature feature = (LabyrinthFeature)ProjectZulu_Core.featureGenerator.getRegisteredStructure("Labyrinth");
                return new ChestWithMeta((Block)Blocks.field_150486_ae, 0, new TileEntityChest(), feature.chestLootChance, feature.chestMaxLoot);
            }
            return new BlockWithMeta(Blocks.field_150350_a);
        }
        if (piecePos.field_71574_a == 0 || piecePos.field_71574_a == cellSize - 1 || piecePos.field_71573_c == 0 || piecePos.field_71573_c == cellSize - 1) {
            return new BlockWithMeta(Blocks.field_150417_aV, 2);
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public String getIdentifier() {
        return "labyrinthhiddenwall";
    }
}

