/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint.cathedral;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.BoundaryPair;
import com.stek101.projectzulu.common.world2.CellHelper;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;

public class BPCathedralEntrance
implements Blueprint {
    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        return this.getWallBlock(CellHelper.mirrorCellTo(piecePos, cellSize, cellIndexDirection), cellSize, cellHeight, random, cellIndexDirection);
    }

    public BlockWithMeta getWallBlock(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        int slopeBelow;
        int slope;
        BlockWithMeta woodenPlank = new BlockWithMeta(Blocks.field_150344_f, 1);
        BlockWithMeta woodenStair = new BlockWithMeta(Blocks.field_150485_bF);
        ArrayList<BlockWithMeta> wallBlocks = new ArrayList<BlockWithMeta>(3);
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 2, 8));
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 1, 8));
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 0, 100));
        if (piecePos.field_71572_b > cellHeight - cellSize) {
            slope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a - 3, 1.0f, BoundaryPair.createPair(0, cellSize * 2 - 8), cellHeight - cellSize / 3);
            slopeBelow = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a - 2, 1.0f, BoundaryPair.createPair(0, cellSize * 2 - 8), cellHeight - cellSize / 3);
            if (slope == 0) {
                if (slope != slopeBelow) {
                    return new BlockWithMeta(woodenStair.block, this.getStairMeta(cellIndexDirection));
                }
                return woodenPlank;
            }
            if (slope > 0) {
                return new BlockWithMeta(Blocks.field_150350_a);
            }
        }
        if (cellIndexDirection == CellIndexDirection.SouthWestCorner || cellIndexDirection == CellIndexDirection.SouthEastCorner) {
            if (piecePos.field_71573_c == 1 && piecePos.field_71574_a > 2) {
                if (piecePos.field_71574_a == cellSize - 1 && piecePos.field_71572_b > 0 && piecePos.field_71572_b < 4) {
                    return new BlockWithMeta(Blocks.field_150350_a);
                }
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
            slope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a - 3, 1.0f, BoundaryPair.createPair(1, cellSize * 2 - 7), cellHeight - cellSize);
            if (slope < 0 && piecePos.field_71573_c == 0) {
                if (piecePos.field_71574_a == cellSize * 4 / 10) {
                    if (piecePos.field_71572_b % 2 == 0) {
                        return new BlockWithMeta(Blocks.field_150390_bg, cellIndexDirection == CellIndexDirection.SouthWestCorner ? 0 : 1);
                    }
                    return new BlockWithMeta(Blocks.field_150390_bg, cellIndexDirection == CellIndexDirection.SouthWestCorner ? 4 : 5);
                }
                if (piecePos.field_71574_a == cellSize * 4 / 10 + 1) {
                    if (piecePos.field_71572_b % 2 == 0) {
                        return new BlockWithMeta(Blocks.field_150390_bg, cellIndexDirection == CellIndexDirection.SouthWestCorner ? 1 : 0);
                    }
                    return new BlockWithMeta(Blocks.field_150390_bg, cellIndexDirection == CellIndexDirection.SouthWestCorner ? 5 : 4);
                }
                if (piecePos.field_71574_a > cellSize * 4 / 10 && piecePos.field_71572_b == 0) {
                    return new BlockWithMeta(Blocks.field_150390_bg, 3);
                }
            }
            if (piecePos.field_71573_c == 0 && piecePos.field_71574_a > 2 && piecePos.field_71572_b < 4) {
                return new BlockWithMeta(Blocks.field_150350_a);
            }
        }
        if (piecePos.field_71574_a <= 2 && piecePos.field_71573_c == 1) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
        }
        if (piecePos.field_71572_b > cellHeight - 2 * cellSize) {
            slope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a - 3, 1.0f, BoundaryPair.createPair(1, cellSize * 2 - 7), cellHeight - cellSize);
            slopeBelow = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a - 2, 1.0f, BoundaryPair.createPair(1, cellSize * 2 - 7), cellHeight - cellSize);
            if (slope == 0) {
                if (slope != slopeBelow) {
                    if (piecePos.field_71573_c <= 1) {
                        return new BlockWithMeta(woodenStair.block, this.getStairMeta(cellIndexDirection));
                    }
                    return new BlockWithMeta(Blocks.field_150390_bg, this.getStairMeta(cellIndexDirection));
                }
                if (piecePos.field_71573_c <= 1 && (cellIndexDirection == CellIndexDirection.SouthWestCorner || cellIndexDirection == CellIndexDirection.SouthEastCorner)) {
                    return woodenPlank;
                }
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
            if (piecePos.field_71573_c > 1 && slope > 0 && slope <= 2) {
                return new BlockWithMeta(Blocks.field_150350_a);
            }
            int topAarchSlope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a + 0, 1.0f, BoundaryPair.createPair(1, cellSize * 2), cellHeight - cellSize);
            int botAarchSlope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a + 1, 1.0f, BoundaryPair.createPair(1, cellSize * 2), cellHeight - cellSize);
            if ((topAarchSlope == 0 || botAarchSlope == 0) && piecePos.field_71573_c % 3 == 1 && piecePos.field_71574_a > cellSize * 4 / 10) {
                return new BlockWithMeta(woodenStair.block, this.getArchStairMeta(cellIndexDirection, topAarchSlope == 0));
            }
        }
        if (piecePos.field_71574_a == cellSize * 4 / 10 && (piecePos.field_71573_c <= 3 || piecePos.field_71572_b >= 5) && (piecePos.field_71573_c >= 1 || cellIndexDirection != CellIndexDirection.SouthWestCorner && cellIndexDirection != CellIndexDirection.SouthEastCorner)) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
        }
        if (piecePos.field_71572_b == 1 && (piecePos.field_71574_a == cellSize - 1 || piecePos.field_71573_c == cellSize - 1)) {
            return new BlockWithMeta(Blocks.field_150404_cg, 14);
        }
        if (piecePos.field_71572_b == 0) {
            if (piecePos.field_71574_a == cellSize * 4 / 10 + 1 && (piecePos.field_71573_c <= 3 || piecePos.field_71572_b >= 5)) {
                return new BlockWithMeta(Blocks.field_150347_e, 0);
            }
            if (piecePos.field_71574_a > cellSize * 4 / 10) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
            if (piecePos.field_71573_c > 0) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    private int getStairMeta(CellIndexDirection cellIndexDirection) {
        switch (cellIndexDirection) {
            case NorthWestCorner: 
            case SouthWestCorner: {
                return 0;
            }
            case NorthEastCorner: 
            case SouthEastCorner: {
                return 1;
            }
        }
        return 0;
    }

    public int getArchStairMeta(CellIndexDirection cellIndexDirection, boolean top) {
        switch (cellIndexDirection) {
            case NorthWestCorner: 
            case SouthWestCorner: {
                return top ? 0 : 5;
            }
            case NorthEastCorner: 
            case SouthEastCorner: {
                return top ? 1 : 4;
            }
        }
        return 0;
    }

    public int getDoorPillarStairMeta(CellIndexDirection cellIndexDirection, boolean top, boolean left) {
        switch (cellIndexDirection) {
            case SouthWestCorner: {
                if (top) {
                    return left ? 0 : 5;
                }
                return left ? 4 : 5;
            }
            case SouthEastCorner: {
                if (top) {
                    return left ? 0 : 5;
                }
                return left ? 0 : 5;
            }
        }
        return 0;
    }

    @Override
    public String getIdentifier() {
        return "CathedralEntrance";
    }

    @Override
    public int getWeight() {
        return 0;
    }
}

