/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint.cathedral;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.BoundaryPair;
import com.stek101.projectzulu.common.world2.CellHelper;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;

public class BPCathedralHallwayEnd
implements Blueprint {
    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        piecePos = this.applyMirror(piecePos, cellSize, cellIndexDirection);
        piecePos = this.applyRotation(piecePos, cellSize, cellIndexDirection);
        return this.getWallBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.NorthWall), cellSize, cellHeight, random, cellIndexDirection);
    }

    private ChunkCoordinates applyMirror(ChunkCoordinates piecePos, int cellSize, CellIndexDirection cellIndexDirection) {
        if (cellIndexDirection == CellIndexDirection.NorthWestCorner || cellIndexDirection == CellIndexDirection.NorthEastCorner || cellIndexDirection == CellIndexDirection.SouthEastCorner || cellIndexDirection == CellIndexDirection.SouthWestCorner) {
            piecePos = CellHelper.mirrorCellTo(piecePos, cellSize, CellIndexDirection.SouthWestCorner);
        }
        return piecePos;
    }

    private ChunkCoordinates applyRotation(ChunkCoordinates piecePos, int cellSize, CellIndexDirection cellIndexDirection) {
        piecePos = cellIndexDirection == CellIndexDirection.NorthWestCorner ? CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.NorthWall) : (cellIndexDirection == CellIndexDirection.NorthEastCorner ? CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.WestWall) : (cellIndexDirection == CellIndexDirection.SouthEastCorner ? CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.SouthWall) : (cellIndexDirection == CellIndexDirection.SouthWestCorner ? CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.EastWall) : CellHelper.rotateCellTo(piecePos, cellSize, cellIndexDirection))));
        return piecePos;
    }

    public BlockWithMeta getWallBlock(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        int slopeBelow;
        int slope;
        BlockWithMeta woodenPlank = new BlockWithMeta(Blocks.field_150344_f, 1);
        BlockWithMeta woodenStair = new BlockWithMeta(Blocks.field_150485_bF);
        ArrayList<BlockWithMeta> wallBlocks = new ArrayList<BlockWithMeta>(3);
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 2, 8));
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 1, 8));
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 0, 100));
        if (piecePos.field_71572_b > cellHeight - cellSize) {
            slope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71573_c - 3, 1.0f, BoundaryPair.createPair(0, cellSize * 2 - 8), cellHeight - cellSize / 3);
            slopeBelow = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71573_c - 2, 1.0f, BoundaryPair.createPair(0, cellSize * 2 - 8), cellHeight - cellSize / 3);
            if (slope == 0) {
                if (slope != slopeBelow) {
                    return new BlockWithMeta(woodenStair.block, this.getStairMeta(cellIndexDirection));
                }
                return woodenPlank;
            }
            if (slope > 0) {
                return new BlockWithMeta(Blocks.field_150350_a);
            }
        }
        if (piecePos.field_71574_a != 0 && piecePos.field_71573_c == 2) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
        }
        slope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71573_c - 3, 1.0f, BoundaryPair.createPair(1, cellSize * 2 - 8), cellHeight - cellSize);
        slopeBelow = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71573_c - 2, 1.0f, BoundaryPair.createPair(1, cellSize * 2 - 8), cellHeight - cellSize);
        if (slope == 0) {
            if (slope != slopeBelow) {
                return new BlockWithMeta(woodenStair.block, this.getStairMeta(cellIndexDirection));
            }
            if (piecePos.field_71574_a < 1) {
                return woodenPlank;
            }
            return new BlockWithMeta(Blocks.field_150417_aV, 5, this.getStairMeta(cellIndexDirection));
        }
        if (slope > 0 && piecePos.field_71574_a > 1 && piecePos.field_71573_c > 2) {
            if (piecePos.field_71574_a == cellSize - 1 && piecePos.field_71573_c == 3) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
            if (piecePos.field_71573_c == cellSize - 1 && piecePos.field_71574_a == 3 && slope == 1) {
                return new BlockWithMeta(woodenStair.block, this.getArchStairMeta(cellIndexDirection, false));
            }
            if (slope < 4 && (piecePos.field_71574_a == 2 || piecePos.field_71573_c == 3)) {
                return new BlockWithMeta(Blocks.field_150342_X);
            }
        }
        int topAarchSlope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71573_c + 0, 1.0f, BoundaryPair.createPair(1, cellSize * 2), cellHeight - cellSize);
        int botAarchSlope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71573_c + 1, 1.0f, BoundaryPair.createPair(1, cellSize * 2), cellHeight - cellSize);
        if ((topAarchSlope == 0 || botAarchSlope == 0) && piecePos.field_71574_a % 3 == 1 && piecePos.field_71573_c > cellSize * 4 / 10 && piecePos.field_71574_a > 1) {
            return new BlockWithMeta(woodenStair.block, this.getArchStairMeta(cellIndexDirection, topAarchSlope == 0));
        }
        if (piecePos.field_71574_a == 1 && piecePos.field_71573_c > cellSize * 4 / 10) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
        }
        if (piecePos.field_71572_b == 0 && piecePos.field_71574_a > 0 && piecePos.field_71573_c > cellSize * 4 / 10) {
            if (piecePos.field_71573_c == cellSize * 4 / 10 + 1) {
                return new BlockWithMeta(Blocks.field_150347_e);
            }
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
        }
        if (piecePos.field_71572_b == 1 && piecePos.field_71574_a > 1 && piecePos.field_71574_a % 2 == 0) {
            if (piecePos.field_71573_c == cellSize * 4 / 10 + 2) {
                return new BlockWithMeta(Blocks.field_150476_ad, this.getPewStairMeta(cellIndexDirection));
            }
            if (piecePos.field_71573_c > cellSize * 4 / 10 + 2) {
                return new BlockWithMeta((Block)Blocks.field_150376_bx);
            }
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    private int getStairMeta(CellIndexDirection cellIndexDirection) {
        switch (cellIndexDirection) {
            case WestWall: 
            case NorthEastCorner: {
                return 0;
            }
            case EastWall: 
            case SouthWestCorner: {
                return 1;
            }
            case SouthWall: 
            case NorthWestCorner: {
                return 3;
            }
        }
        return 2;
    }

    private int getArchStairMeta(CellIndexDirection cellIndexDirection, boolean top) {
        switch (cellIndexDirection) {
            case NorthWall: 
            case SouthEastCorner: {
                return top ? 2 : 7;
            }
            case SouthWall: 
            case NorthWestCorner: {
                return top ? 3 : 6;
            }
            case WestWall: 
            case NorthEastCorner: {
                return top ? 0 : 5;
            }
            case EastWall: 
            case SouthWestCorner: {
                return top ? 1 : 4;
            }
        }
        return 0;
    }

    private int getPewStairMeta(CellIndexDirection cellIndexDirection) {
        switch (cellIndexDirection) {
            case NorthWall: 
            case SouthEastCorner: {
                return 3;
            }
            case SouthWall: 
            case NorthWestCorner: {
                return 2;
            }
            case WestWall: 
            case NorthEastCorner: {
                return 1;
            }
            case EastWall: 
            case SouthWestCorner: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String getIdentifier() {
        return "BPCathedralHallwayEnd";
    }

    @Override
    public int getWeight() {
        return 0;
    }
}

