/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.buildingmanager;

import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.Architect;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public abstract class BuildingManagerBase
implements BuildingManager {
    public World world;
    protected int blueprintPasses = 1;

    public BuildingManagerBase(World world) {
        this.world = world;
    }

    @Override
    public final void generate() {
        this.randomizeCells();
        for (int i = 1; i <= this.blueprintPasses; ++i) {
            this.assignBlueprints(i, this.blueprintPasses);
        }
        this.construct();
    }

    protected ChunkCoordinates calcTranslatedPosition(TerrainFeature.FeatureDirection direction, ChunkCoordinates startingPos, int xWidth, int zWidth, int height) {
        if (direction == null) {
            direction = TerrainFeature.FeatureDirection.CENTERED;
        }
        switch (direction) {
            case NORTH: {
                return new ChunkCoordinates(startingPos.field_71574_a - xWidth / 2, startingPos.field_71572_b, startingPos.field_71573_c - zWidth);
            }
            case SOUTH: {
                return new ChunkCoordinates(startingPos.field_71574_a - xWidth / 2, startingPos.field_71572_b, startingPos.field_71573_c + 1);
            }
            case WEST: {
                return new ChunkCoordinates(startingPos.field_71574_a - xWidth, startingPos.field_71572_b, startingPos.field_71573_c - zWidth / 2);
            }
            case EAST: {
                return new ChunkCoordinates(startingPos.field_71574_a + 1, startingPos.field_71572_b, startingPos.field_71573_c - zWidth / 2);
            }
        }
        return new ChunkCoordinates(startingPos.field_71574_a - xWidth / 2, startingPos.field_71572_b, startingPos.field_71573_c - zWidth / 2);
    }

    protected abstract void randomizeCells();

    protected abstract void assignBlueprints(int var1, int var2);

    protected abstract void construct();

    protected void processCellPieces(MazeCell currentCell, Architect architect) {
        ChunkCoordinates pieceCoords = new ChunkCoordinates(0, 0, 0);
        for (int pieceX = 0; pieceX < currentCell.size; ++pieceX) {
            for (int pieceZ = 0; pieceZ < currentCell.size; ++pieceZ) {
                for (int pieceY = 0; pieceY < currentCell.getHeight(); ++pieceY) {
                    pieceCoords.func_71571_b(pieceX, pieceY, pieceZ);
                    BlockWithMeta block = architect.getBlockFromBlueprint(currentCell, new ChunkCoordinates(pieceCoords));
                    pieceCoords.func_71571_b(currentCell.initialPos.field_71574_a + pieceX, currentCell.initialPos.field_71572_b + pieceY, currentCell.initialPos.field_71573_c + pieceZ);
                    this.handleBlockPlacement(block, pieceCoords, this.world.field_73012_v);
                }
            }
        }
    }

    protected void handleBlockPlacement(BlockWithMeta blockWithMeta, ChunkCoordinates position, Random random) {
        if (blockWithMeta == null || !this.world.func_72899_e(position.field_71574_a, position.field_71572_b, position.field_71573_c)) {
            return;
        }
        TileEntity tileEntity = this.world.func_147438_o(position.field_71574_a, position.field_71572_b, position.field_71573_c);
        if (tileEntity != null) {
            tileEntity.func_145843_s();
            this.world.func_147475_p(position.field_71574_a, position.field_71572_b, position.field_71573_c);
            this.world.func_147449_b(position.field_71574_a, position.field_71572_b, position.field_71573_c, Block.func_149684_b((String)"air"));
        } else {
            blockWithMeta.placeBlock(this.world, position, random);
        }
    }
}

