/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.buildingmanager;

import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectCemetary;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManagerBase;
import com.stek101.projectzulu.common.world2.randomizer.Randomizer;
import com.stek101.projectzulu.common.world2.randomizer.SelectedFewRandomizer;
import java.awt.Point;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class BuildingManagerCemetary
extends BuildingManagerBase {
    public ArchitectCemetary architect;
    public Randomizer randomizer;
    MazeCell[][] cemetary;

    public BuildingManagerCemetary(World world, ChunkCoordinates startingPos, TerrainFeature.FeatureDirection direction) {
        super(world);
        this.architect = new ArchitectCemetary(world);
        this.randomizer = new SelectedFewRandomizer(world.field_73012_v, 3, 10, false);
        int xCells = 6;
        int zCells = 6;
        int cellSize = 3;
        int cellHeight = 5;
        startingPos = this.calcTranslatedPosition(direction, startingPos, xCells * cellSize, zCells * cellSize, cellHeight);
        this.cemetary = new MazeCell[xCells][zCells];
        for (int i = 0; i < this.cemetary.length; ++i) {
            for (int j = 0; j < this.cemetary[0].length; ++j) {
                this.cemetary[i][j] = new MazeCell(cellSize, cellHeight, new ChunkCoordinates(startingPos.field_71574_a + cellSize * i, startingPos.field_71572_b, startingPos.field_71573_c + cellSize * j));
            }
        }
    }

    @Override
    protected void randomizeCells() {
        this.randomizer.randomize(this.cemetary);
    }

    @Override
    protected void assignBlueprints(int pass, int maxPass) {
        if (pass == maxPass) {
            for (int cellX = 0; cellX < this.cemetary.length; ++cellX) {
                for (int cellZ = 0; cellZ < this.cemetary[0].length; ++cellZ) {
                    this.architect.assignBlueprint(this.cemetary, new Point(cellX, cellZ), pass, maxPass);
                }
            }
        }
    }

    @Override
    protected void construct() {
        for (int cellX = 0; cellX < this.cemetary.length; ++cellX) {
            for (int cellZ = 0; cellZ < this.cemetary[0].length; ++cellZ) {
                MazeCell currentCell = this.cemetary[cellX][cellZ];
                this.processCellPieces(currentCell, this.architect);
            }
        }
    }

    @Override
    protected void handleBlockPlacement(BlockWithMeta blockWithMeta, ChunkCoordinates position, Random random) {
        Block blockAt = this.world.func_147439_a(position.field_71574_a, position.field_71572_b, position.field_71573_c);
        if (blockWithMeta.block.equals(Blocks.field_150350_a) && blockAt.equals(Block.func_149684_b((String)"snow"))) {
            return;
        }
        if (blockAt.func_149688_o().equals(Material.field_151575_d) || blockAt.func_149688_o().equals(Material.field_151584_j)) {
            return;
        }
        super.handleBlockPlacement(blockWithMeta, position, random);
    }
}

