/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.common.world.features.trees.WorldGenBOPSwampTree;
import biomesoplenty.common.world.features.trees.WorldGenMangrove;
import biomesoplenty.common.world.features.trees.WorldGenPalmTree1;
import biomesoplenty.common.world.features.trees.WorldGenPineTree;
import biomesoplenty.common.world.features.trees.WorldGenRainforestTree1;
import biomesoplenty.common.world.features.trees.WorldGenRedwoodTree2;
import biomesoplenty.common.world.features.trees.WorldGenSacredOak;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBOPColorizedSapling
extends BlockSapling {
    private static final String[] saplings = new String[]{"sacredoak", "mangrove", "palm", "redwood", "willow", "pine", "mahogany"};
    private IIcon[] textures;

    public BlockBOPColorizedSapling() {
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        this.func_149855_e(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.func_149855_e(world, x, y, z);
        super.func_149695_a(world, x, y, z, block);
    }

    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack itemStack) {
        return this.canBlockStay(world, x, y, z, itemStack.func_77960_j());
    }

    @Deprecated
    public boolean func_149718_j(World world, int x, int y, int z) {
        return super.func_149718_j(world, x, y, z);
    }

    public boolean canBlockStay(World world, int x, int y, int z, int metadata) {
        Block block = world.func_147439_a(x, y - 1, z);
        switch (metadata) {
            case 1: {
                return block == Blocks.field_150354_m;
            }
        }
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    protected void func_149855_e(World world, int x, int y, int z) {
        if (!this.canBlockStay(world, x, y, z, world.func_72805_g(x, y, z))) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[saplings.length];
        for (int i = 0; i < saplings.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("biomesoplenty:sapling_" + saplings[i]);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= saplings.length) {
            meta = 0;
        }
        return this.textures[meta];
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < saplings.length; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        switch (meta) {
            case 1: {
                return block == Blocks.field_150354_m;
            }
        }
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149878_d(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z) & 7;
        WorldGenAbstractTree obj = null;
        int rnd = random.nextInt(8);
        if (obj == null) {
            switch (meta) {
                case 0: {
                    obj = new WorldGenSacredOak(false);
                    break;
                }
                case 1: {
                    obj = new WorldGenMangrove();
                    break;
                }
                case 2: {
                    rnd = random.nextInt(4);
                    if (rnd == 0) {
                        obj = new WorldGenPalmTree1();
                        break;
                    }
                    obj = new WorldGenPalmTree1(25, 8, 1.5);
                    break;
                }
                case 3: {
                    obj = new WorldGenRedwoodTree2(BOPCBlocks.logs3, BOPCBlocks.colorizedLeaves1, 0, 3, false, 20, 15);
                    break;
                }
                case 4: {
                    obj = new WorldGenBOPSwampTree(BOPCBlocks.logs3, BOPCBlocks.colorizedLeaves2, 1, 0, 6, 9, BOPCBlocks.colorizedLeaves2, 0);
                    break;
                }
                case 5: {
                    obj = new WorldGenPineTree();
                    break;
                }
                case 6: {
                    obj = new WorldGenRainforestTree1(BOPCBlocks.logs4, BOPCBlocks.colorizedLeaves2, 3, 2, false, 8, 8);
                }
            }
        }
        if (obj != null) {
            world.func_147468_f(x, y, z);
            if (!((WorldGenerator)obj).func_76484_a(world, random, x, y, z)) {
                world.func_147465_d(x, y, z, (Block)this, meta, 2);
            }
        }
    }

    public int func_149692_a(int meta) {
        return MathHelper.func_76125_a((int)(meta & 7), (int)0, (int)(saplings.length - 1));
    }
}

