/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.features.nether;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.biome.BOPBiomeDecorator;
import biomesoplenty.api.biome.BiomeFeatures;
import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.common.world.generation.WorldGeneratorBOP;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;

public class WorldGenWaspHive
extends WorldGeneratorBOP {
    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int baseWidth = 4 + rand.nextInt(2);
        int baseHeight = 8 + rand.nextInt(2);
        for (int air = 0; air < 26; ++air) {
            if (world.func_147439_a(x, y + 3, z) == Blocks.field_150424_aL && world.func_147437_c(x, y + 2 - air, z)) continue;
            return false;
        }
        for (int cubeno = 0; cubeno < 4; ++cubeno) {
            float chance = 0.0f;
            int meta = 0;
            switch (cubeno) {
                case 0: {
                    chance = 0.25f;
                    meta = 0;
                    break;
                }
                case 1: {
                    chance = 1.0f;
                    meta = 0;
                    break;
                }
                case 2: {
                    chance = 1.0f;
                    meta = 1;
                    break;
                }
                case 3: {
                    chance = 0.5f;
                    meta = 1;
                }
            }
            int honeychance = rand.nextInt(2);
            this.generateHiveCubeSmall(world, x, y + cubeno, z, baseHeight - 11 + cubeno * 2, baseWidth - 1 + cubeno, cubeno, chance, meta);
            this.generateHiveCube(world, x, y - 2 + cubeno, z, baseHeight + cubeno * 2, baseWidth + cubeno, cubeno, chance, honeychance, meta);
            this.generateHiveCubeSmall(world, x, y - (baseHeight + 6) + cubeno, z, baseHeight - 10 + cubeno * 2, baseWidth - 1 + cubeno, cubeno, chance, meta);
            this.generateHiveCubeSmall(world, x, y - (baseHeight + 7) + cubeno, z, baseHeight - 9 + cubeno * 2, baseWidth - 2 + cubeno, cubeno, chance, meta);
            this.generateHiveCubeSmall(world, x, y - (baseHeight + 9) + cubeno, z, baseHeight - 9 + cubeno * 2, baseWidth - 4 + cubeno, cubeno, chance, meta);
            this.spawnWasps(world, rand, x, y, z);
            this.spawnEmptyHoneycombs(world, rand, x, y, z);
            this.spawnFilledHoneycombs(world, rand, x, y, z);
        }
        return true;
    }

    @Override
    public void setupGeneration(World world, Random random, BOPBiome biome, String featureName, int x, int z) {
        for (int i = 0; i < (Integer)((BiomeFeatures)((BOPBiomeDecorator)((Object)biome.field_76760_I)).bopFeatures).getFeature(featureName); ++i) {
            int j = random.nextInt(4);
            if (j == 0) continue;
            int randX = x + random.nextInt(16) + 8;
            int randY = random.nextInt(64) + 50;
            int randZ = z + random.nextInt(16) + 8;
            this.func_76484_a(world, random, randX, randY, randZ);
        }
    }

    public void generateHiveCube(World world, int origx, int origy, int origz, int height, int width, int cubeno, float chance, int honeychance, int meta) {
        for (int hLayer = 0; hLayer < height; ++hLayer) {
            for (int i = -width; i < width; ++i) {
                for (int j = -width; j < width; ++j) {
                    if ((hLayer == 0 || hLayer == height - 1) && world.field_73012_v.nextFloat() <= chance) {
                        world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.hive, meta, 2);
                    } else if ((i == -width || i == width - 1 || j == -width || j == width - 1) && world.field_73012_v.nextFloat() <= chance) {
                        world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.hive, meta, 2);
                    }
                    if (hLayer > height / 2) {
                        if (honeychance == 0) {
                            if (cubeno < 2 && world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive) {
                                world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.honey, 7, 2);
                            }
                            if (cubeno >= 2 || world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                            world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.honey, 7, 2);
                            continue;
                        }
                        if (cubeno < 2 && world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive) {
                            world.func_147468_f(origx + i, origy - hLayer, origz + j);
                        }
                        if (cubeno >= 2 || world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                        world.func_147468_f(origx + i, origy - hLayer, origz + j);
                        continue;
                    }
                    if (honeychance == 0) {
                        if (hLayer == height / 2) {
                            if (cubeno < 2 && world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive) {
                                world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.honeyBlock, 0, 2);
                            }
                            if (cubeno >= 2 || world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                            world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.honeyBlock, 0, 2);
                            continue;
                        }
                        if (cubeno < 2 && world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive) {
                            world.func_147468_f(origx + i, origy - hLayer, origz + j);
                        }
                        if (cubeno >= 2 || world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                        world.func_147468_f(origx + i, origy - hLayer, origz + j);
                        continue;
                    }
                    if (cubeno < 2 && world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive) {
                        world.func_147468_f(origx + i, origy - hLayer, origz + j);
                    }
                    if (cubeno >= 2 || world.func_147439_a(origx + i, origy - hLayer, origz + j) != BOPCBlocks.hive || world.func_72805_g(origx + i, origy - hLayer, origz + j) == 0) continue;
                    world.func_147468_f(origx + i, origy - hLayer, origz + j);
                }
            }
        }
    }

    public void generateHiveCubeSmall(World world, int origx, int origy, int origz, int height, int width, int cubeno, float chance, int meta) {
        for (int hLayer = 0; hLayer < height; ++hLayer) {
            for (int i = -width; i < width; ++i) {
                for (int j = -width; j < width; ++j) {
                    if ((hLayer == 0 || hLayer == height - 1) && world.field_73012_v.nextFloat() <= chance) {
                        world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.hive, 1, 2);
                        continue;
                    }
                    if (i != -width && i != width - 1 && j != -width && j != width - 1 || !(world.field_73012_v.nextFloat() <= chance)) continue;
                    world.func_147465_d(origx + i, origy - hLayer, origz + j, BOPCBlocks.hive, 1, 2);
                }
            }
        }
    }

    public void spawnWasps(World world, Random rand, int x, int y, int z) {
        for (int spawn = 0; spawn < 50; ++spawn) {
            int spawnz;
            int spawny;
            int spawnx = x - 12 + rand.nextInt(24);
            if (world.func_147439_a(spawnx, spawny = y - rand.nextInt(24), spawnz = z - 12 + rand.nextInt(24)) != BOPCBlocks.hive || world.func_72805_g(spawnx, spawny, spawnz) != 1 || world.func_147439_a(spawnx - 1, spawny, spawnz) != BOPCBlocks.hive || world.func_147439_a(spawnx + 1, spawny, spawnz) != BOPCBlocks.hive || world.func_147439_a(spawnx, spawny, spawnz - 1) != BOPCBlocks.hive || world.func_147439_a(spawnx, spawny, spawnz + 1) != BOPCBlocks.hive || world.func_147439_a(spawnx, spawny - 1, spawnz) != BOPCBlocks.hive || world.func_147439_a(spawnx, spawny + 1, spawnz) != BOPCBlocks.hive || world.func_72805_g(spawnx - 1, spawny, spawnz) != 1 || world.func_72805_g(spawnx + 1, spawny, spawnz) != 1 || world.func_72805_g(spawnx, spawny, spawnz - 1) != 1 || world.func_72805_g(spawnx, spawny, spawnz + 1) != 1 || world.func_72805_g(spawnx, spawny - 1, spawnz) != 1 || world.func_72805_g(spawnx, spawny + 1, spawnz) != 1) continue;
            world.func_147449_b(spawnx, spawny, spawnz, Blocks.field_150474_ac);
            TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_147438_o(spawnx, spawny, spawnz);
            if (tileentitymobspawner == null) continue;
            tileentitymobspawner.func_145881_a().func_98272_a("BiomesOPlenty.Wasp");
        }
    }

    public void spawnEmptyHoneycombs(World world, Random rand, int x, int y, int z) {
        for (int spawn = 0; spawn < 50; ++spawn) {
            int spawnz;
            int spawny;
            int spawnx = x - 8 + rand.nextInt(16);
            if (world.func_147439_a(spawnx, spawny = y - rand.nextInt(12), spawnz = z - 8 + rand.nextInt(16)) != BOPCBlocks.hive || world.func_72805_g(spawnx, spawny, spawnz) != 0) continue;
            world.func_147465_d(spawnx, spawny, spawnz, BOPCBlocks.hive, 2, 2);
        }
    }

    public void spawnFilledHoneycombs(World world, Random rand, int x, int y, int z) {
        for (int spawn = 0; spawn < 20; ++spawn) {
            int spawnz;
            int spawny;
            int spawnx = x - 8 + rand.nextInt(16);
            if (world.func_147439_a(spawnx, spawny = y - rand.nextInt(12), spawnz = z - 8 + rand.nextInt(16)) != BOPCBlocks.hive || world.func_72805_g(spawnx, spawny, spawnz) != 0) continue;
            world.func_147465_d(spawnx, spawny, spawnz, BOPCBlocks.hive, 3, 2);
        }
    }
}

