/*
 * Decompiled with CFR 0.152.
 */
package theboo.mods.customrecipes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import theboo.mods.customrecipes.RecipeLoader;
import theboo.mods.customrecipes.handlers.CustomRecipesEvents;
import theboo.mods.customrecipes.lib.Reference;
import theboo.mods.customrecipes.logger.Logger;
import theboo.mods.customrecipes.network.proxy.CommonProxy;

@Mod(modid="customrecipes", name="Custom Recipes", version="4.72", dependencies="required-after:Forge@[9.11.0.884,)")
public class CustomRecipes {
    public static Configuration config;
    public RecipeLoader loader = new RecipeLoader();
    @Mod.Instance(value="customrecipes")
    public static CustomRecipes instance;
    @SidedProxy(clientSide="theboo.mods.customrecipes.network.proxy.ClientProxy", serverSide="theboo.mods.customrecipes.network.proxy.CommonProxy")
    public static CommonProxy proxy;

    public File getWorkingFolder() {
        try {
            File toBeReturned = FMLCommonHandler.instance().getSide().isClient() ? Minecraft.func_71410_x().field_71412_D : MinecraftServer.func_71276_C().func_71209_f("");
            return toBeReturned;
        }
        catch (Exception ex) {
            Logger.log(Level.FATAL, "Couldn't get the path to the mod directory.");
            return null;
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fml) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Closing Custom Recipes log...");
                Logger.logClose();
            }
        }, "Shutdown-hook-thread"));
        config = new Configuration(fml.getSuggestedConfigurationFile());
        this.loadConfig(config);
        MinecraftForge.EVENT_BUS.register((Object)new CustomRecipesEvents());
    }

    @Mod.EventHandler
    public void load(FMLPostInitializationEvent fml) {
        System.out.println();
        System.out.println();
        Logger.log(Level.INFO, "=== CustomRecipes ===\n *** Created by MightyPork *** \n *** Developed by TheBoo ***\n\n" + new Date().toString() + "\n\nSave your recipe files into .minecraft/mods/customrecipes.\n");
        GameRegistry.registerFuelHandler((IFuelHandler)this.loader);
        this.loader.loadRecipes();
    }

    private void loadConfig(Configuration c) {
        c.load();
        Reference.DEBUG = c.get("general", "Enable Extensive Log Messages [Debug Mode]", false).getBoolean(false);
        c.save();
    }

    public static URL getUpdateURL() {
        try {
            return new URL("http://pastebin.com/raw.php?i=T3afBrCS");
        }
        catch (MalformedURLException ex) {
            System.out.println("Woops, URL was wrong!");
            return null;
        }
    }
}

