/*
 * Decompiled with CFR 0.152.
 */
package theboo.mods.customrecipes;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.Level;
import theboo.mods.customrecipes.CustomRecipes;
import theboo.mods.customrecipes.dictionary.Dictionary;
import theboo.mods.customrecipes.logger.Logger;

public class RecipeLoader
implements IFuelHandler {
    private Hashtable<String, ItemStack> dict = new Hashtable();
    private Hashtable<String, Integer> fuels = new Hashtable();
    private int DICT_VERSION = 0;
    public static RecipeLoader instance;
    public String[] syntaxes;
    private boolean isGoodNull = false;
    private String path;
    private static final String ERR_MSG_UNDEFINED = "Undefined alias or wrong ID (no such block or item exists).\nIf you are trying to get a mod item, try adding 256 to the id value.";
    private static final String ERR_MSG_SYNTAX = "Syntax error.";
    private static final String ERR_MSG_SHAPE = "Recipe is not rectangular or is larger than 3x3.";
    private static final String ERR_MSG_NOBURNTIME = "No burn time specified. Recipe does not make sense.";

    public RecipeLoader() {
        instance = this;
        this.syntaxes = new String[64];
    }

    public int getFuel(int i, int j) {
        String identifier = Integer.toString(i) + "." + Integer.toString(j);
        if (this.fuels.get(identifier) == null) {
            return 0;
        }
        return this.fuels.get(identifier);
    }

    public int getBurnTime(ItemStack fuel) {
        return this.getFuel(Item.func_150891_b((Item)fuel.func_77973_b()), fuel.func_77960_j());
    }

    public void loadRecipes() {
        boolean fail;
        boolean bl = fail = !new File(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/dictionary.txt").exists();
        if (fail) {
            new File(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/").mkdirs();
            this.regenerateDictionary();
            fail = false;
            Logger.log(Level.INFO, "Creating dictionary file.\n");
        }
        this.loadRecipeFile(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/dictionary.txt", false);
        Logger.log(Level.INFO, "Loading dictionary.txt");
        if (this.DICT_VERSION != 37) {
            new File(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/").mkdirs();
            this.regenerateDictionary();
            this.DICT_VERSION = 37;
            Logger.log(Level.INFO, "\nRecipe dictionary is outdated.\nBuilding new dictionary.\n");
            this.loadRecipeFile(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/dictionary.txt", false);
            Logger.log(Level.INFO, "Loading dictionary.txt");
        }
        File dir = new File(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".") && !name.substring(name.length() - 1).equals("~");
            }
        };
        boolean bl2 = fail = !new File(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/dictionary_custom.txt").exists();
        if (fail) {
            new File(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/").mkdirs();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/dictionary_custom.txt"));
                out.write("# *** CUSTOM DICTIONARY ***\n# Here you can define aliases for mod items and blocks.\n#\n# To prevent confussion: You CAN'T create new blocks and items with this file.\n# They are added by other mods. This file only lets you define aliases for these items.\n#\n# This file will be read right after dictionary.txt to make sure\n# all your following recipes (in other files) can access these aliases.\n#\n# Example alias definition:\n# silmarilShoes = 7859\n# rubyGem = 9958,13  where 9958 is ID, 13 is DAMAGE\n#\n\n");
                fail = false;
                out.close();
                Logger.log(Level.INFO, "Creating empty file for Custom Dictionary.\n");
            }
            catch (IOException ioe) {
                Logger.log(Level.WARN, "* I/O ERROR: Could not create Custom Dictionary file.\n");
            }
        }
        Logger.log(Level.INFO, "Loading custom dictionary: dictionary_custom.txt");
        this.loadRecipeFile(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/dictionary_custom.txt", true);
        this.generateAliasByLocalizedName();
        String[] children = dir.list(filter);
        if (children == null) {
            fail = true;
        } else {
            for (int i = 0; i < children.length; ++i) {
                String filename = children[i];
                if (filename.equals("dictionary.txt") || filename.equals("dictionary_custom.txt")) continue;
                Logger.log(Level.INFO, "Loading recipes: " + filename);
                this.loadRecipeFile(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/" + filename, true);
            }
        }
        if (fail) {
            Logger.log(Level.INFO, "Dictionary not found, creating new one.");
            new File(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/").mkdirs();
            this.regenerateDictionary();
        }
        Logger.log(Level.INFO, "Recipes loaded.\n\n");
    }

    private void regenerateDictionary() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(CustomRecipes.instance.getWorkingFolder() + "/mods/customrecipes/dictionary.txt"));
            for (int a = 0; a < Dictionary.AliasDictionary.length; ++a) {
                out.write(Dictionary.AliasDictionary[a]);
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            Logger.log(Level.WARN, "* I/O ERROR: Could not regenerate the dictionary in .minecraft/mods/customrecipes/dictionary.txt");
        }
    }

    public void generateAliasByLocalizedName() {
        Logger.log(Level.INFO, "Adding all the items localized names as dictionary entries...");
        try {
            for (Object i : GameData.getItemRegistry().func_148742_b().toArray()) {
                Item item = (Item)GameData.getItemRegistry().func_82594_a(i);
                if (item == null) continue;
                this.dict.put(StatCollector.func_74838_a((String)item.func_77658_a()).replace(" ", ""), new ItemStack(item, 1, 0));
                this.dict.put(StatCollector.func_74838_a((String)item.func_77658_a()).replace(" ", "").toLowerCase(), new ItemStack(item, 1, 0));
                this.dict.put(item.func_77658_a().substring(5).replace(" ", ""), new ItemStack(item, 1, 0));
                this.dict.put(item.func_77658_a().substring(5).replace(" ", "").toLowerCase(), new ItemStack(item, 1, 0));
            }
            for (Object b : GameData.getBlockRegistry().func_148742_b().toArray()) {
                Block block = (Block)GameData.getBlockRegistry().func_82594_a(b);
                if (block == null) continue;
                this.dict.put(block.func_149732_F().replace(" ", ""), new ItemStack(block, 1, 0));
                this.dict.put(block.func_149732_F().replace(" ", "").toLowerCase(), new ItemStack(block, 1, 0));
                this.dict.put(block.func_149739_a().substring(5).replace(" ", ""), new ItemStack(block, 1, 0));
                this.dict.put(block.func_149739_a().substring(5).replace(" ", "").toLowerCase(), new ItemStack(block, 1, 0));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            Logger.log(Level.WARN, "Failed to add items unlocalized names as dictionary entries, BUT prevented a crash. This is probably an issue from a mod developer.");
        }
    }

    private int getNumberFromString(String str) {
        try {
            int tmpi = Integer.valueOf(str);
            if (tmpi < -1) {
                return Short.MAX_VALUE;
            }
            return tmpi < -1 ? 0 : tmpi;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private int getAnyNumberFromString(String str) {
        try {
            int tmpi = Integer.valueOf(str);
            if (tmpi == -1) {
                return Short.MAX_VALUE;
            }
            return tmpi;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean isValidItem(int i) {
        if (i > 0 && i < 32000) {
            return i < 4096 && Block.func_149729_e((int)i) != null || i >= 256 && Item.func_150899_d((int)i) != null;
        }
        return false;
    }

    private ItemStack getStackFromAliasOrNumber(String str) {
        this.isGoodNull = false;
        if (str.equalsIgnoreCase("null") || str.equalsIgnoreCase("none") || str.equalsIgnoreCase("nothing") || str.equalsIgnoreCase("empty") || str.equalsIgnoreCase("air")) {
            this.isGoodNull = true;
            return null;
        }
        try {
            int tmpi = Integer.valueOf(str.trim());
            if (this.isValidItem(tmpi)) {
                return new ItemStack(Item.func_150899_d((int)tmpi), 1, 0);
            }
            this.errorUndefined(this.path, str, str);
            return null;
        }
        catch (NumberFormatException e) {
            if (this.dict.get(str.toLowerCase()) != null) {
                ItemStack obj = this.dict.get(str.toLowerCase());
                if (obj instanceof ItemStack) {
                    return obj.func_77946_l();
                }
                if (obj instanceof Item) {
                    return new ItemStack((Item)obj, 1, 0);
                }
                if (obj instanceof Block) {
                    return new ItemStack((Block)obj, 1, 0);
                }
                System.out.println("CR: INVALID DICTIONARY ENTRY! @ " + this.path);
                return null;
            }
            return null;
        }
    }

    private ItemStack getRecipeStack(String str) {
        return this.parseStack(str, false);
    }

    private ItemStack getProductStack(String str) {
        return this.parseStack(str, true);
    }

    private ItemStack parseStack(String str, boolean acceptSize) {
        String[] parts = str.split("[,]");
        if (parts.length >= 1) {
            ItemStack stack1 = this.getStackFromAliasOrNumber(parts[0]);
            if (stack1 == null) {
                if (!this.isGoodNull) {
                    this.errorUndefined(this.path, str, str);
                }
                return null;
            }
            ItemStack stack = stack1.func_77946_l();
            if (parts.length >= 2) {
                if (!acceptSize) {
                    int dmg = this.getAnyNumberFromString(parts[1]);
                    if (dmg >= 32000 && dmg != Short.MAX_VALUE) {
                        this.errorAlert(this.path, str, "Warning - invalid item damage.");
                    } else {
                        stack.func_77964_b(dmg);
                    }
                } else {
                    int size = this.getNumberFromString(parts[1]);
                    if (size < 0 || size > 256) {
                        this.errorAlert(this.path, str, "Warning - invalid stack size.");
                    } else {
                        stack.field_77994_a = size;
                        if (parts.length >= 3) {
                            int dmg = this.getNumberFromString(parts[2]);
                            if (dmg >= 32000) {
                                this.errorAlert(this.path, str, "Warning - invalid item damage.");
                            } else {
                                stack.func_77964_b(dmg);
                            }
                        }
                    }
                }
            }
            if (acceptSize && stack.func_77960_j() == -1) {
                stack.func_77964_b(0);
            }
            return stack;
        }
        this.errorUndefined(this.path, str, str);
        return null;
    }

    private int getRecipeId(String str) {
        ItemStack stack = this.getStackFromAliasOrNumber(str);
        if (stack == null) {
            return -1;
        }
        return Item.func_150891_b((Item)stack.func_77973_b());
    }

    private void loadRecipeFile(String file_path, boolean log) {
        ArrayList rawFile = this.readFile(file_path);
        this.path = file_path;
        if (log) {
            Logger.log(Level.INFO, "Started to load recipes at " + file_path);
        }
        for (int a = 0; a < rawFile.size(); ++a) {
            String entry;
            if (log) {
                Logger.log(Level.INFO, "Loading recipe syntaxes at " + file_path);
            }
            String entryOrig = entry = (String)rawFile.get(a);
            if (entry.length() >= 4 && entry.substring(0, 1).equals("*")) {
                if (log) {
                    Logger.log(Level.INFO, "Found alias syntax in " + file_path);
                }
                this.parseRecipeAlias(file_path, entryOrig, entry);
                continue;
            }
            if (entry.length() >= 16 && entry.substring(0, 9).equals("shapeless")) {
                if (log) {
                    Logger.log(Level.INFO, "Found shapeless syntax in " + file_path);
                }
                this.parseRecipeShapeless(file_path, entryOrig, entry);
                continue;
            }
            if (entry.length() >= 9 && entry.substring(0, 4).equals("fuel")) {
                if (log) {
                    Logger.log(Level.INFO, "Found fuel syntax in " + file_path);
                }
                this.parseRecipeFuel(file_path, entryOrig, entry);
                continue;
            }
            if (entry.length() >= 15 && entry.substring(0, 8).equals("smelting")) {
                if (log) {
                    Logger.log(Level.INFO, "Found smelting syntax in " + file_path);
                }
                this.parseRecipeSmelting(file_path, entryOrig, entry);
                continue;
            }
            if (entry.length() >= 13 && entry.substring(0, 6).equals("shaped")) {
                if (log) {
                    Logger.log(Level.INFO, "Found shaped syntax in " + file_path);
                }
                this.parseRecipeShaped(file_path, entryOrig, entry);
                continue;
            }
            if (entry.length() >= 13 && entry.substring(0, 6).equals("remove")) {
                if (log) {
                    Logger.log(Level.INFO, "Found remove syntax in " + file_path);
                }
                this.parseRecipeRemove(file_path, entryOrig, entry);
                continue;
            }
            if (entry.length() < 10 || !entry.substring(0, 5).equals("clear")) continue;
            if (log) {
                Logger.log(Level.INFO, "Found clear syntax in " + file_path);
            }
            this.parseRecipeClear(file_path, entryOrig, entry);
        }
    }

    private void errorAlert(String fpath, String line, String cause) {
        Logger.log(Level.FATAL, "\n* ERROR in recipe file \"" + fpath + "\": " + line + "\n" + (cause == null ? "" : "  " + cause + "\n"));
    }

    private void errorUndefined(String fpath, String line, String fail) {
        this.errorAlert(fpath, line, "  " + fail + " -> " + ERR_MSG_UNDEFINED);
    }

    private void errorSyntax(String fpath, String line) {
        this.errorAlert(fpath, line, ERR_MSG_SYNTAX);
    }

    private static Object[] OAappend(Object[] source, Object what) {
        Object[] tmp = new Object[source.length + 1];
        for (int a = 0; a < source.length; ++a) {
            tmp[a] = source[a];
        }
        tmp[source.length] = what;
        return tmp;
    }

    private static Object[] OAappendAll(Object[] source, Object[] what) {
        int a;
        Object[] tmp = new Object[source.length + what.length];
        for (a = 0; a < source.length; ++a) {
            tmp[a] = source[a];
        }
        for (a = 0; a < what.length; ++a) {
            tmp[source.length + a] = what[a];
        }
        return tmp;
    }

    private ArrayList readFile(String url) {
        File file = new File(url);
        FileInputStream fis = null;
        BufferedReader reader = null;
        ArrayList<String> fileContents = new ArrayList<String>();
        try {
            fis = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(fis));
            String tmpString = reader.readLine();
            while (tmpString != null) {
                tmpString = tmpString.replaceAll("#.*$", "");
                if (!(tmpString = tmpString.replaceAll("//.*$", "")).equals("") && !tmpString.equals("\n")) {
                    tmpString = tmpString.replaceAll(" ", "");
                    tmpString = tmpString.replaceAll("\t", "");
                    tmpString = tmpString.replaceAll(":", ",");
                    if ((tmpString = tmpString.replaceAll("[/|;]", "/")).length() >= 4 && tmpString.substring(0, 1).equals("*") || tmpString.length() >= 9 && tmpString.substring(0, 4).equals("fuel") || tmpString.length() >= 13 && tmpString.substring(0, 6).equals("shaped") || tmpString.length() >= 16 && tmpString.substring(0, 9).equals("shapeless") || tmpString.length() >= 15 && tmpString.substring(0, 8).equals("smelting") || tmpString.length() >= 13 && tmpString.substring(0, 6).equals("remove") || tmpString.length() >= 10 && tmpString.substring(0, 5).equals("clear")) {
                        fileContents.add(tmpString);
                    } else {
                        Logger.log(Level.WARN, "\nSyntax error in recipe file:\n" + url + "\n-> " + tmpString + "\n");
                    }
                }
                tmpString = reader.readLine();
            }
            reader.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileContents;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseRecipeAlias(String fpath, String entryOrig, String entryo) {
        String entry = entryo.substring(1);
        String[] tokens = entry.split("[=]");
        if (tokens.length != 2) {
            this.errorAlert(fpath, entryOrig, ERR_MSG_SYNTAX);
            return;
        }
        String def = tokens[1];
        if (def == null) {
            this.errorSyntax(fpath, entryOrig);
            return;
        }
        if (tokens[0].equals("DICTIONARY_VERSION")) {
            this.DICT_VERSION = this.getNumberFromString(def);
            return;
        }
        ItemStack stack = this.getRecipeStack(def);
        if (stack != null) {
            this.dict.put(tokens[0].toLowerCase(), stack);
            return;
        }
        this.errorUndefined(fpath, entryOrig, def);
    }

    private void parseRecipeShapeless(String par_path, String par_entryOrig, String par_entry) {
        String path = new String(par_path);
        String entryOrig = new String(par_entryOrig);
        String entry = new String(par_entry);
        String[] tokens = (entry = entry.substring(9)).split("[>]");
        if (tokens.length != 2 || tokens[0].length() < 3 || tokens[1].length() < 3) {
            this.errorAlert(path, entryOrig, ERR_MSG_SYNTAX);
            return;
        }
        String tmp = tokens[0];
        tmp = tmp.replaceAll("[()]", "");
        String[] recipeParts = tmp.split("[+]");
        Object[] recipe = new Object[]{};
        for (int b = 0; b < recipeParts.length; ++b) {
            ItemStack piece = this.getRecipeStack(recipeParts[b]);
            if (piece == null) {
                this.errorUndefined(path, entryOrig, recipeParts[b]);
                return;
            }
            if (piece instanceof Block) {
                piece = new ItemStack((Block)piece, 1, -1);
            }
            recipe = RecipeLoader.OAappend(recipe, piece);
        }
        if (recipe.length <= 0 || recipe.length > 9) {
            this.errorAlert(path, entryOrig, "Bad recipe syntax: Crafting of air, or more than 9 elements.");
            return;
        }
        tmp = tokens[1];
        ItemStack product = this.getProductStack(tmp = tmp.replaceAll("[()]", ""));
        if (product == null) {
            this.errorUndefined(path, entryOrig, tmp);
            return;
        }
        Logger.log(Level.INFO, "LOADED RECIPE");
        GameRegistry.addShapelessRecipe((ItemStack)product, (Object[])recipe);
    }

    private void parseRecipeShaped(String file_path, String entryOrig, String entryo) {
        String entry = entryo.substring(6);
        String[] tokens = entry.split("[>]");
        if (tokens.length != 2 || tokens[0].length() < 3 || tokens[1].length() < 3) {
            this.errorSyntax(file_path, entryOrig);
            return;
        }
        String tmp = tokens[0];
        tmp = tmp.replaceAll("[()]", "");
        String[] rows = tmp.split("[/]");
        int lastRowLength = -1;
        Object[] rowStrings = new Object[]{};
        Object[] explanation = new Object[]{};
        int explCnt = 0;
        Character[] table = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I')};
        if (rows.length < 1 || rows.length > 3) {
            this.errorAlert(file_path, entryOrig, ERR_MSG_SHAPE);
            return;
        }
        int validPieces = 0;
        for (int c = 0; c < rows.length; ++c) {
            String[] recipeParts = rows[c].split("[+]");
            String rowbuilder = "";
            if (lastRowLength != -1 && recipeParts.length != lastRowLength) {
                this.errorAlert(file_path, entryOrig, ERR_MSG_SHAPE);
                return;
            }
            if (recipeParts.length < 1 || recipeParts.length > 3) {
                this.errorAlert(file_path, entryOrig, ERR_MSG_SHAPE);
                return;
            }
            lastRowLength = recipeParts.length;
            for (int b = 0; b < recipeParts.length; ++b) {
                char tmpec = table[explCnt++].charValue();
                rowbuilder = rowbuilder + Character.toString(tmpec);
                ItemStack piece = this.getRecipeStack(recipeParts[b]);
                if (piece == null) continue;
                ++validPieces;
                explanation = RecipeLoader.OAappend(explanation, Character.valueOf(tmpec));
                explanation = RecipeLoader.OAappend(explanation, piece);
            }
            rowStrings = RecipeLoader.OAappend(rowStrings, rowbuilder);
        }
        if (rowStrings.length <= 0) {
            this.errorAlert(file_path, entryOrig, "Crafting of air.");
            return;
        }
        if (validPieces <= 0) {
            this.errorAlert(file_path, entryOrig, "No valid items in recipe.");
            return;
        }
        Object[] recipe = RecipeLoader.OAappendAll(rowStrings, explanation);
        tmp = tokens[1];
        ItemStack product = this.getProductStack(tmp = tmp.replaceAll("[()]", ""));
        if (product == null) {
            this.errorAlert(file_path, entryOrig, "Invalid product " + tmp);
            return;
        }
        try {
            GameRegistry.addRecipe((ItemStack)product, (Object[])recipe);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.log(Level.WARN, "Shaped recipe " + entryOrig + " @ path " + this.path + " threw ArrayIndexOutOfBoundsException");
        }
    }

    private void parseRecipeSmelting(String file_path, String entryOrig, String entryo) {
        String entry = entryo.substring(8);
        String[] tokens = entry.split("[>]");
        if (tokens.length != 2 || tokens[0].length() < 3 || tokens[1].length() < 3) {
            this.errorAlert(file_path, entryOrig, ERR_MSG_SYNTAX);
            return;
        }
        String recipe = tokens[0].replaceAll("[()]", "");
        int intval = this.getRecipeId(recipe);
        if (intval < 1) {
            this.errorUndefined(file_path, entryOrig, recipe);
            return;
        }
        int recipeId = intval;
        String tmp = tokens[1];
        ItemStack product = this.getProductStack(tmp = tmp.replaceAll("[()]", ""));
        if (product == null) {
            this.errorUndefined(file_path, entryOrig, tmp);
            return;
        }
        GameRegistry.addSmelting((Block)Block.func_149729_e((int)recipeId), (ItemStack)product, (float)4.0f);
    }

    private void parseRecipeFuel(String file_path, String entryOrig, String oentry) {
        int burntime;
        String entry = oentry.substring(4);
        String[] tokens = (entry = entry.replaceAll("[()]", "")).split("[,]");
        if (tokens.length < 2 || tokens.length > 3) {
            this.errorAlert(file_path, entryOrig, ERR_MSG_SYNTAX);
            return;
        }
        String tmp = tokens[0];
        ItemStack fuelStack = this.getProductStack(tmp);
        if (fuelStack == null) {
            this.errorUndefined(file_path, entryOrig, tmp);
            return;
        }
        if (tokens.length == 3) {
            fuelStack.func_77964_b(this.getNumberFromString(tokens[1]));
        }
        if ((burntime = this.getNumberFromString(tokens[tokens.length - 1])) <= 0) {
            this.errorAlert(file_path, entryOrig, ERR_MSG_NOBURNTIME);
            return;
        }
        this.fuels.put(Integer.toString(Item.func_150891_b((Item)fuelStack.func_77973_b())) + "." + Integer.toString(fuelStack.func_77960_j()), burntime);
    }

    private void parseRecipeRemove(String file_path, String entryOrig, String entryo) {
        String entry = entryo.substring(6);
        String recipe = entry.replaceAll("[()]", "");
        ItemStack stack = this.getProductStack(recipe);
        Logger.log(Level.INFO, "About to remove recipe with output " + recipe + " itemstack: " + stack.toString());
        this.removeRecipesWithResult(stack, false);
    }

    private void parseRecipeClear(String file_path, String entryOrig, String entryo) {
        String entry = entryo.substring(5);
        String recipe = entry.replaceAll("[()]", "");
        ItemStack stack = this.getProductStack(recipe);
        this.removeRecipesWithResult(stack, true);
    }

    private void removeRecipesWithResult(ItemStack resultItem, boolean clear) {
        ArrayList recipes = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int scan = 0; scan < recipes.size(); ++scan) {
            IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.func_77571_b();
            if (recipeResult == null) {
                Logger.log(Level.WARN, "\nNullPointerExcpetion when browsing through recipes. It should not be a problem though. Recipe index: " + scan + "\n");
                continue;
            }
            if (clear && recipeResult.field_77994_a > 1) {
                resultItem.field_77994_a = recipeResult.field_77994_a;
            }
            if (!ItemStack.func_77989_b((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            Logger.log(Level.INFO, "Removing Recipe: " + recipes.get(scan) + " -> " + recipeResult);
            recipes.remove(scan);
        }
    }
}

