/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import lumien.randomthings.Network.Messages.MessageMagneticForceParticle;
import lumien.randomthings.Network.PacketHandler;
import lumien.randomthings.RandomThings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class MagneticForceHandler {
    public static int TELEPORT_LENGTH = 200;
    public static MagneticForceHandler INSTANCE = new MagneticForceHandler();
    ArrayList<MagneticForceEvent> events = new ArrayList();

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("magneticForces", 9);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            MagneticForceEvent event = new MagneticForceEvent();
            event.readFromNBT(tag);
            this.events.add(event);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (MagneticForceEvent event : this.events) {
            NBTTagCompound tag = new NBTTagCompound();
            event.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("magneticForces", (NBTBase)tagList);
    }

    public void addEvent(String user, String target) {
        this.events.add(new MagneticForceEvent(user, target));
        this.writeToNBT(RandomThings.instance.modNBT);
        RandomThings.instance.saveNBT();
    }

    public void update() {
        int size = this.events.size();
        Iterator<MagneticForceEvent> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            MagneticForceEvent event = iterator.next();
            if (!event.tick()) continue;
            iterator.remove();
        }
        if (size != this.events.size()) {
            this.writeToNBT(RandomThings.instance.modNBT);
            RandomThings.instance.saveNBT();
        }
    }

    private class MagneticForceEvent {
        String user;
        String target;
        int progress;
        float f;

        public MagneticForceEvent(String user, String target) {
            this.user = user;
            this.target = target;
            this.progress = TELEPORT_LENGTH;
            this.f = 0.0f;
        }

        public MagneticForceEvent() {
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.user = nbt.func_74779_i("user");
            this.target = nbt.func_74779_i("target");
            this.progress = nbt.func_74762_e("progress");
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74778_a("user", this.user);
            nbt.func_74778_a("target", this.target);
            nbt.func_74768_a("progress", this.progress);
        }

        public boolean tick() {
            --this.progress;
            if (this.progress <= 0) {
                this.teleport();
                return true;
            }
            this.f += 0.1f;
            EntityPlayerMP userEntity = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.user);
            EntityPlayerMP targetEntity = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.target);
            if (userEntity != null) {
                Set trackingUser = ((WorldServer)userEntity.field_70170_p).func_73039_n().getTrackingPlayers((Entity)userEntity);
                PacketHandler.INSTANCE.sendTo(new MessageMagneticForceParticle(userEntity.func_145782_y(), userEntity.field_70170_p.field_73011_w.field_76574_g, this.f), userEntity);
                for (EntityPlayer player : trackingUser) {
                    PacketHandler.INSTANCE.sendTo(new MessageMagneticForceParticle(userEntity.func_145782_y(), userEntity.field_70170_p.field_73011_w.field_76574_g, this.f), (EntityPlayerMP)player);
                }
            }
            if (targetEntity != null) {
                Set trackingTarget = ((WorldServer)targetEntity.field_70170_p).func_73039_n().getTrackingPlayers((Entity)targetEntity);
                PacketHandler.INSTANCE.sendTo(new MessageMagneticForceParticle(targetEntity.func_145782_y(), targetEntity.field_70170_p.field_73011_w.field_76574_g, this.f), targetEntity);
                for (EntityPlayer player : trackingTarget) {
                    PacketHandler.INSTANCE.sendTo(new MessageMagneticForceParticle(targetEntity.func_145782_y(), targetEntity.field_70170_p.field_73011_w.field_76574_g, this.f), (EntityPlayerMP)player);
                }
            }
            return false;
        }

        private void teleport() {
            EntityPlayerMP userEntity = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.user);
            EntityPlayerMP targetEntity = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.target);
            if (userEntity != null && targetEntity != null) {
                userEntity.func_70078_a(null);
                if (userEntity.field_70170_p.field_73011_w.field_76574_g != targetEntity.field_70170_p.field_73011_w.field_76574_g) {
                    userEntity.func_71027_c(targetEntity.field_70170_p.field_73011_w.field_76574_g);
                }
                userEntity.field_71135_a.func_147364_a(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, targetEntity.field_70177_z, targetEntity.field_70125_A);
            }
        }
    }
}

