/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.creeper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.entity.creeper.EntityMiniCreeper;
import toast.specialMobs.entity.creeper.Entity_SpecialCreeper;

public class EntitySplittingCreeper
extends Entity_SpecialCreeper {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("SpecialMobs:textures/models/creeper/splitting.png")};
    private boolean isExploding;

    public EntitySplittingCreeper(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 2;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70089_S() && this.isExploding) {
            this.func_70829_a(1);
        }
        super.func_70071_h_();
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = powered ? (float)this.field_82226_g * 2.0f : (float)this.field_82226_g;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power - 1.0f, false);
        if (!this.field_70170_p.field_72995_K) {
            EntityMiniCreeper baby = null;
            int i = this.field_70146_Z.nextInt(4) + (int)power;
            while (i-- > 0) {
                baby = new EntityMiniCreeper(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_70624_b(this.func_70638_az());
                baby.func_110161_a(null);
                baby.field_70159_w = (this.field_70146_Z.nextDouble() - 0.5) * (double)power / 3.0;
                baby.field_70179_y = (this.field_70146_Z.nextDouble() - 0.5) * (double)power / 3.0;
                baby.field_70122_E = false;
                if (powered) {
                    baby.func_70096_w().func_75692_b(17, (Object)1);
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            this.field_70170_p.func_72956_a((Entity)baby, "random.pop", 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource != null && damageSource.func_76364_f() != damageSource.func_76346_g()) {
            this.isExploding = true;
        }
        return super.func_70097_a(damageSource, damage);
    }

    @Override
    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("Explode", this.isExploding);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74767_n("Explode")) {
            this.isExploding = true;
        }
    }
}

