/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.enderman;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.entity.enderman.Entity_SpecialEnderman;

public class EntityThiefEnderman
extends Entity_SpecialEnderman {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("SpecialMobs:textures/models/enderman/thief.png"), new ResourceLocation("SpecialMobs:textures/models/enderman/thief_eyes.png")};

    public EntityThiefEnderman(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        ++this.field_70728_aV;
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.3);
    }

    @Override
    protected void onTypeAttack(Entity target) {
        int i;
        if (target instanceof EntityLivingBase) {
            i = 64;
            while (i-- > 0 && !this.teleportTarget((EntityLivingBase)target)) {
            }
        }
        i = 64;
        while (i-- > 0 && !this.func_70820_n()) {
        }
    }

    @Override
    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
        this.func_145779_a(Items.field_151079_bi, 1);
    }

    protected void func_70600_l(int superRare) {
        Item[] armor = new Item[]{Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T};
        String[] armorNames = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};
        int choice = this.field_70146_Z.nextInt(armor.length);
        ItemStack itemStack = new ItemStack(armor[choice]);
        String name = armorNames[choice];
        EffectHelper.setItemName(itemStack, "Ender " + name, 13);
        EffectHelper.addItemText(itemStack, "\u00a77\u00a7oSeems to distort reality");
        EffectHelper.addItemText(itemStack, "\u00a77\u00a7o... or something");
        EffectHelper.dye(itemStack, 0);
        EffectHelper.enchantItem(this.field_70146_Z, itemStack, 30);
        EffectHelper.overrideEnchantment(itemStack, Enchantment.field_77328_g, 10);
        this.func_70099_a(itemStack, 0.0f);
    }

    private boolean teleportTarget(EntityLivingBase target) {
        int blockZ;
        int blockY;
        double xI = target.field_70165_t;
        double yI = target.field_70163_u;
        double zI = target.field_70161_v;
        target.field_70165_t += (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        target.field_70163_u += (double)(this.field_70146_Z.nextInt(32) - 16);
        target.field_70161_v += (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        boolean canTeleport = false;
        int blockX = (int)Math.floor(target.field_70165_t);
        if (this.field_70170_p.func_72899_e(blockX, blockY = (int)Math.floor(target.field_70163_u), blockZ = (int)Math.floor(target.field_70161_v))) {
            boolean onGround = false;
            while (blockY > 0) {
                Block block = this.field_70170_p.func_147439_a(blockX, blockY - 1, blockZ);
                if (block != null && block.func_149688_o().func_76230_c()) {
                    onGround = true;
                    break;
                }
                target.field_70163_u -= 1.0;
                --blockY;
            }
            if (onGround) {
                target.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                if (target.field_70170_p.func_72945_a((Entity)target, target.field_70121_D).isEmpty() && !target.field_70170_p.func_72953_d(target.field_70121_D)) {
                    canTeleport = true;
                }
            }
        }
        if (!canTeleport) {
            target.func_70107_b(xI, yI, zI);
            return false;
        }
        if (!(target instanceof EntityPlayerMP) || ((EntityPlayerMP)target).field_71135_a.func_147362_b().func_150724_d()) {
            target.func_70634_a(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        }
        target.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        target.field_70170_p.func_72908_a(xI, yI, zI, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

