/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import dmillerw.tml.data.NBTKeyAndTag;
import dmillerw.tml.helper.GsonHelper;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTDeserializer
implements JsonDeserializer<NBTTagCompound> {
    public NBTTagCompound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry elementEntry : json.getAsJsonObject().entrySet()) {
            String key = (String)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            this.parseJsonElement(nbt, key, element);
        }
        return nbt;
    }

    public void parseJsonElement(NBTTagCompound nbt, String key, JsonElement element) {
        NBTKeyAndTag nbtKeyAndTag = this.getTagFromElement(key, element);
        nbt.func_74782_a(nbtKeyAndTag.key, nbtKeyAndTag.tag);
    }

    public NBTKeyAndTag getTagFromElement(String key, JsonElement element) {
        if (element.isJsonPrimitive()) {
            return new NBTKeyAndTag(key, this.getTagFromPrimitive(element.getAsJsonPrimitive()));
        }
        if (element.isJsonArray()) {
            NBTTagList nbtTagList = new NBTTagList();
            for (JsonElement jsonElement : element.getAsJsonArray()) {
                nbtTagList.func_74742_a(this.getTagFromElement((String)key, (JsonElement)jsonElement).tag);
            }
            return new NBTKeyAndTag(key, (NBTBase)nbtTagList);
        }
        if (element.isJsonObject()) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry elementEntry : element.getAsJsonObject().entrySet()) {
                this.parseJsonElement(tag, (String)elementEntry.getKey(), (JsonElement)elementEntry.getValue());
            }
            return new NBTKeyAndTag(key, (NBTBase)tag);
        }
        return new NBTKeyAndTag(key, (NBTBase)new NBTTagString(element.getAsString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NBTBase getTagFromPrimitive(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return new NBTTagByte((byte)(primitive.getAsBoolean() ? 1 : 0));
        }
        if (primitive.isString()) {
            String string = primitive.getAsString();
            boolean properString = false;
            if (Character.isAlphabetic(string.charAt(string.length() - 1))) {
                for (int i = 0; i < string.length() - 2; ++i) {
                    char c = string.charAt(i);
                    if (!Character.isAlphabetic(c)) continue;
                    properString = true;
                    break;
                }
            }
            if (properString) return new NBTTagString(primitive.getAsString());
            Number number = GsonHelper.parseNumber(string.charAt(string.length() - 1), primitive);
            if (number instanceof Byte) {
                return new NBTTagByte(number.byteValue());
            }
            if (number instanceof Short) {
                return new NBTTagShort(number.shortValue());
            }
            if (number instanceof Integer) {
                return new NBTTagInt(number.intValue());
            }
            if (number instanceof Float) {
                return new NBTTagFloat(number.floatValue());
            }
            if (number instanceof Double) {
                return new NBTTagDouble(number.doubleValue());
            }
            if (!(number instanceof Long)) return null;
            return new NBTTagLong(number.longValue());
        }
        if (!primitive.isNumber()) throw new JsonParseException("Failed to retrieve NBT tag from non-primitive element!");
        if (!primitive.getAsString().contains(".")) return new NBTTagInt(primitive.getAsInt());
        return new NBTTagDouble(primitive.getAsDouble());
    }
}

