/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.crusher.ContainerCrusher;
import crazypants.enderio.machine.crusher.GuiCrusher;
import crazypants.enderio.machine.crusher.PacketGrindingBall;
import crazypants.enderio.machine.crusher.TileCrusher;
import crazypants.enderio.network.PacketHandler;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrusher
extends AbstractMachineBlock {
    public static BlockCrusher create() {
        PacketHandler.INSTANCE.registerMessage(PacketGrindingBall.class, PacketGrindingBall.class, PacketHandler.nextID(), Side.CLIENT);
        BlockCrusher res = new BlockCrusher();
        res.init();
        return res;
    }

    private BlockCrusher() {
        super(ModObject.blockSagMill, TileCrusher.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCrusher) {
            return new ContainerCrusher(player.field_71071_by, (TileCrusher)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCrusher) {
            return new GuiCrusher(player.field_71071_by, (TileCrusher)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 6;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:crusherFrontOn";
        }
        return "enderio:crusherFront";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileCrusher te = (TileCrusher)world.func_147438_o(x, y, z);
        if (te != null && te.isActive()) {
            ForgeDirection front = ForgeDirection.values()[te.facing];
            for (int i = 0; i < 3; ++i) {
                double px = (double)x + 0.5 + (double)front.offsetX * 0.51;
                double pz = (double)z + 0.5 + (double)front.offsetZ * 0.51;
                double py = (float)y + world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                double v = 0.05;
                double vx = 0.0;
                double vz = 0.0;
                if (front == ForgeDirection.NORTH || front == ForgeDirection.SOUTH) {
                    px += (double)world.field_73012_v.nextFloat() * 0.8 - 0.4;
                    vz += front == ForgeDirection.NORTH ? -v : v;
                } else {
                    pz += (double)world.field_73012_v.nextFloat() * 0.8 - 0.4;
                    vx += front == ForgeDirection.WEST ? -v : v;
                }
                world.func_72869_a("smoke", px, py, pz, vx, 0.0, vz);
            }
        }
    }
}

